/*
%%% copyright-cmetz-97
This software is Copyright 1997 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#if INET6
#include <netinet6/in6.h>
#endif /* INET6 */

int inner_addrcmp(struct sockaddr *sa1, struct sockaddr *sa2)
{
#if SALEN
  if (sa1->sa_len != sa2->sa_len)
    return (sa1->sa_len < sa2->sa_len) ? -1 : 1;
#endif /* SALEN */
  if (sa1->sa_family != sa2->sa_family)
    return (sa1->sa_family < sa2->sa_family) ? -1 : 1;

  switch(sa1->sa_family) {
    case AF_INET:
      return memcmp(&((struct sockaddr_in *)sa1)->sin_addr, &((struct sockaddr_in *)sa2)->sin_addr, sizeof(struct in_addr));
#if INET6
    case AF_INET6:
      return memcmp(&((struct sockaddr_in6 *)sa1)->sin6_addr, &((struct sockaddr_in6 *)sa2)->sin6_addr, sizeof(struct in6_addr));
#endif /* INET6 */
    default:
      return -1;
  };
};
