/*
%%% copyright-cmetz-97

*/
#ifndef _SUPPORT_H
#define _SUPPORT_H 1

#if INET6
#include <netinet6/in6.h>
#endif /* INET6 */
#if LOCAL
#include <sys/un.h>
#endif /* LOCAL */
#include <netdb.h>

#include "support-nrl.h"

int inner_addrcmp(struct sockaddr *sa1, struct sockaddr *sa2);
int inner_connect(struct addrinfo *ai, char *request, int requestlen, int (*trying_callback)(struct sockaddr *sa), int (*error_callback)(char *myname, char *message), char *myname, struct addrinfo **pai);

#if !defined(AF_LOCAL) && defined(AF_UNIX)
#define AF_LOCAL AF_UNIX
#endif /* !defined(AF_LOCAL) && defined(AF_UNIX) */
#if !defined(PF_LOCAL) && defined(PF_UNIX)
#define PF_LOCAL PF_UNIX
#endif /* !defined(PF_LOCAL) && defined(PF_UNIX) */

union sockaddr_union {
  struct sockaddr sa;
  struct sockaddr_in sin;
#if INET6
  struct sockaddr_in6 sin6;
#endif /* INET6 */
#if LOCAL
  struct sockaddr_un sun;
#endif /* LOCAL */
  char __pad[128];
};
#define SU union sockaddr_union
#endif /* _SUPPORT_H */
