# %%% copyright-cmetz-96
# This software is Copyright 1996-1997 by Craig Metz, All Rights Reserved.
# The Inner Net License Version 2 applies to this software.
# You should have received a copy of the license with this software. If
# you didn't get a copy, you may request one from <license@inner.net>.
#

# Directories in which to install things.  If these are not specified
# the default values used would overwrite most of the corresponding
# IPv4 only utilities.
#

INSTALLED=0

ifneq ($(INSTALLED), 0)
ifndef CONFIG_DIR
CONFIG_DIR=@CONFIG_DIR@
endif # CONFIG_DIR

include $(CONFIG_DIR)/GNUmakefile.config
else # INSTALLED
ifndef DOTS
DOTS=../
endif # DOTS

include ${DOTS}GNUmakefile.config
endif # INSTALLED

ifneq ($(SEGREGATE_EXECUTABLES), 0)
LIBEXECDIR=	/libexec
USR_BINDIR=	/bin
USR_SBINDIR=	/sbin
SBINDIR=	/sbin
SCRIPTDIR=	/bin
else # SEGREGATE_EXECUTABLES
LIBEXECDIR=	/bin
USR_BINDIR=	/bin
USR_SBINDIR=	/bin
SBINDIR=	/bin
SCRIPTDIR=	/bin
endif # SEGREGATE_EXECUTABLES

INCDIR=		/include
LIBDIR= 	/lib
MANDIR=		/man

# C flags common to all the utilities.
#
CFLAGS+=-g
ifneq ($(INSTALLED), 0)
CFLAGS+=-I$(DESTDIR)$(INCDIR)
else # INSTALLED
CFLAGS+=-I$(DOTS)include
ifeq ($(LIBCAPI), 0)
CFLAGS+=-I$(DOTS)include/generic
ifeq ($(OS), Linux)
CFLAGS+=-I$(DOTS)include/linux
endif # OS = Linux
endif # !LIBCAPI
endif # INSTALLED

ifeq ($(OS),NetBSD)
44BSD=1
endif # OS = NetBSD
ifeq ($(OS),BSD/OS)
44BSD=1
endif # OS = BSD/OS
ifeq ($(OS),4.4BSD)
44BSD=1
endif # OS = 4.4BSD
ifeq ($(OS),Linux)
44BSD=0
endif # OS = Linux

ifeq ($(INSTALLED), 0)
ifeq ($(LIBCAPI), 0)
ifneq ($(44BSD), 0)
CFLAGS+=-I$(DOTS)../sys
endif # 44BSD
endif # !LIBCAPI
endif # !INSTALLED

ifneq ($(INET6), 0)
DINET6=-DINET6=$(INET6)
endif # INET6
ifneq ($(NETSEC), 0)
DIPSEC=-DNETSEC=$(NETSEC)
endif # NETSEC
ifneq ($(FASTCTO), 0)
DFASTCTO=-DFASTCTO=$(FASTCTO)
endif # FASTCTO
ifneq ($(INNER), 0)
DINNER=-DINNER=$(INNER)
endif # INNER
ifneq ($(SALEN), 0)
CFLAGS+=-DSALEN=$(SALEN)
endif # SALEN

# Libraries used by the utilities.
#
ifneq ($(INSTALLED), 0)
LOADLIBES+=-L$(DESTDIR)$(LIBDIR) -linet6
else # INSTALLED
LOADLIBES+=-L${DOTS}support -linet6
endif # INSTALLED

ifneq ($(LIBRESOLV), "")
LOADLIBES+=$(LIBRESOLV)
endif # LIBRESOLV
ifneq ($(LIBEFENCE), 0)
LOADLIBES+=-lefence
endif # LIBEFENCE
