# Directories in which to install things.  If these are not specified
# the default values used would overwrite most of the corresponding
# IPv4 only utilities.
#
ifndef DOTS
DOTS=../
endif

include ${DOTS}GNUmakefile.config

ifneq ($(SEGREGATE_EXECUTABLES), 0)
LIBEXECDIR=	/libexec
USR_BINDIR=	/bin
USR_SBINDIR=	/sbin
SBINDIR=	/sbin
SCRIPTDIR=	/bin
else
LIBEXECDIR=	/bin
USR_BINDIR=	/bin
USR_SBINDIR=	/bin
SBINDIR=	/bin
SCRIPTDIR=	/bin
endif

INCDIR=		/include
LIBDIR= 	/lib
MANDIR=		/man

# C flags common to all the utilities.
#
CFLAGS+=-g -I$(DOTS)support
ifeq ($(OS),Linux)
CFLAGS+=-I$(DOTS)/include
endif
ifeq ($(OS),4.4BSD)
CFLAGS+=-I/usr/inet6/src/sys
endif
ifneq ($(INET6), 0)
DINET6=-DINET6=$(INET6)
endif
ifneq ($(IPSEC), 0)
DIPSEC=-DIPSEC=$(IPSEC) -DIPSEC_NEWAPI=$(IPSEC_NEWAPI)
endif
ifneq ($(IPV4CIDR), 0)
DIPV4CIDR=-DIPV4CIDR=$(IPV4CIDR)
endif
ifneq ($(FASTCTO), 0)
DFASTCTO=-DFASTCTO=$(FASTCTO)
endif
ifneq ($(SALEN), 0)
CFLAGS+=-DSALEN=$(SALEN)
endif

# Libraries used by the utilities.
#
LOADLIBES+=-L${DOTS}support -linet6
ifneq ($(LIBRESOLV), 0)
LOADLIBES+=-lresolv
endif
