#
#	Upper Buttons
#
proc make_group_menu  {} {
    msg_Make "Making group cascading menus" 0
    update
    grp_menu
    .top.m.menu delete 1
    msg_destroy
}

proc mksedit {} {
    Sedit_Pref
#    exmh_bind_e
    wm minsize .seditpref 0 0
#   Sedit_Pref clears entry Class bindings
    bind .seditpref <Unmap> {after 1000 setup_bindings}
}

proc mksedit_compose {} {
    Sedit_ComposeUI
    wm minsize .compose 0 0
}

proc menu_sedit {} {
    Preferences_Dialog
    .pref.but.save configure -command nn_PreferencesSave
}

proc do_uri {} {
    if {[catch {Uri_ScanMsg .more.t}] != 0} {
	URI_ScanMsg .more.t
    }
}

proc top_buttons {} {
    global token Config has_exmh nn_x_dir

    frame .top 
    frame .top.x -borderwidth 2  -relief ridge
    
    if {[winfo screendepth .] > 8} {
	image create photo nn -file $nn_x_dir/tcl/nn.ppm
    } else {
	image create bitmap nn -file $nn_x_dir/tcl/nn.xbm
    }
    button .top.pic -image nn -borderwidth 1  \
	-relief sunken  -highlightthickness 0 -padx 3 -pady 4

    menubutton .top.m -text "Groups" -menu .top.m.menu -bd 1 \
	-relief raised -padx 5 -pady 3
    menu .top.m.menu
    if {!$Config(mk_group_menu)} {
	.top.m.menu add command -label "Setup Groups menu" \
	    -command "make_group_menu"
    }
    
    menubutton .top.a -text "article" -menu .top.a.art -bd 1 \
	-relief raised -padx 5 -pady 3
    menu .top.a.art
    .top.a.art add command -label "Post news" \
        -command "put_extended {post}"
    .top.a.art  add command -label "Followup news" \
	-command "put_extended {follow}"
    .top.a.art add separator
    .top.a.art  add command -label "Mail article" \
	-command "put_extended {mail}"
    .top.a.art  add command -label "Mail reply" \
	-command "put_extended {reply}"
    .top.a.art add separator
    .top.a.art add cascade -label "Process articles" -menu .top.a.art.a
    menu .top.a.art.a 
    .top.a.art.a  add command -label "Turn URLs into Buttons" \
	-command do_uri
    .top.a.art.a  add command -label "Treat selection as URL" \
	-command URI_OpenSelection
    .top.a.art.a  add command -label "View using PGP" \
	-command "put_extended {pgp}"
    .top.a.art.a add separator
    .top.a.art.a  add command -label "decode" \
	-command "put_extended {decode}"
    .top.a.art.a  add command -label "deview" \
	-command "put_extended {deview}"
    .top.a.art.a  add command -label "patch" \
	-command "put_extended {patch}"
    .top.a.art.a  add command -label "print" \
	-command "put_extended {print}"
    .top.a.art.a  add command -label "unshar" \
	-command "put_extended {unshar}"
     .top.a.art add cascade -label "Save articles" -menu .top.a.art.s
    menu .top.a.art.s
    .top.a.art.s  add command -label "save-body" \
	-command "put_extended {save-body}"
    .top.a.art.s  add command -label "save-short" \
	-command "put_extended {save-short}"
    .top.a.art.s  add command -label "save-full" \
	-command "put_extended {save-full}"
    .top.a.art add cascade -label "misc" \
	-menu .top.a.art.m
    menu .top.a.art.m
    .top.a.art.m add command -label "full headers" \
	-command "put_extended {page=0}"
    .top.a.art.m add separator
    .top.a.art.m add command -label "leave-next" \
	-command "put_extended {leave-next}"
    .top.a.art.m add command -label "leave-article" \
	-command "put_extended {leave-article}"
    .top.a.art.m add separator
    .top.a.art.m add command -label "rot13" \
	-command "put_extended {rot13}"
    .top.a.art.m add command -label "compress" \
	-command "put_extended {compress}"
    .top.a.art.m add command -label "full-digest" \
	-command "put_extended {full-digest}"
    
    menubutton .top.f -text "functs" -menu .top.f.func -bd 1 \
	-relief raised -padx 5 -pady 3
    menu .top.f.func
    .top.f.func add command -label "reload groups" \
	-command "put_extended {reload} m"
    .top.f.func add cascade -label "make window" -menu .top.f.func.w
    menu .top.f.func.w
    .top.f.func.w add command -label "group list" \
	-command "list_Make .groups grp_list"
    .top.f.func.w add command -label "folder list" \
	-command "list_Make .folders folder_list"
    .top.f.func add command -label "define Kill/Select" \
	-command "put_extended {kill-select}"
    .top.f.func add command -label "cancel articles" \
	-command "put_extended {cancel}"
    .top.f.func add command -label "(un)subscribe group" \
	-command "put_extended {unsub}"
    .top.f.func add separator
    .top.f.func add command -label "previous message" \
	-command "put_funct $token(K_LAST_MESSAGE)"
    
    menubutton .top.o -text "menu" -menu .top.o.others -bd 1 \
	-relief raised -padx 5 -pady 3
    menu .top.o.others
    .top.o.others add cascade -label "sort type" -menu .top.o.others.s
    menu .top.o.others.s
    .top.o.others.s add command -label "Sort: arrival" \
	-command "put_extended {sort arrival}"
    .top.o.others.s add command -label "Sort: subject" \
	-command "put_extended {sort subject}"
    .top.o.others.s add command -label "Sort: lexical" \
	-command "put_extended {sort lexical}"
    .top.o.others.s add command -label "Sort: age" \
	-command "put_extended {sort age}"
    .top.o.others.s add command -label "Sort: sender" \
	-command "put_extended {sort sender}"
    .top.o.others.s add command -label "Sort: thread lexical" \
	-command "put_extended {sort thread-lexical}"
    .top.o.others.s add command -label "Sort: thread age" \
	-command "put_extended {sort thread-date}"
    .top.o.others add cascade -label "consolidate menu" \
	-menu .top.o.others.c
    menu .top.o.others.c
    .top.o.others.c add command -label "Menu: consolidate" \
	-command "put_extended {set consolidated-menu on}"
    .top.o.others.c add command -label "Menu: unconsolidate" \
	-command "put_extended {set consolidated-menu off}"
    .top.o.others add cascade -label "menu mode" -menu .top.o.others.m
    menu .top.o.others.m
    .top.o.others.m add command -label "select regexp" \
	-command "put_extended {find}"
    .top.o.others.m add command -label "select-auto" \
	-command "put_extended {select-auto}"
    .top.o.others.m add command -label "select-invert" \
	-command "put_extended {select-invert}"
    .top.o.others.m add command -label "select-range" \
	-command "put_extended {select-range}"
    .top.o.others.m add command -label "unselect-all" \
	-command "put_extended {unselect-all}"
    .top.o.others.m add separator
    .top.o.others.m add command -label "first page" \
	-command "put_extended {page=1}"
    .top.o.others.m add command -label "last page" \
	-command "put_extended {page=$}"
    .top.o.others.m add separator
    .top.o.others.m add command -label "open-subject" \
	-command "put_extended {open-subject}"
    .top.o.others.m add command -label "close-subject" \
	-command "put_extended {close-subject}"
    .top.o.others.m add separator
    .top.o.others.m add command -label "continue-no-mark" \
	-command "put_extended {continue-no-mark}"
    .top.o.others.m add command -label "read-return" \
	-command "put_extended {read-return}"
    .top.o.others.m add command -label "unread" \
	-command "put_extended {unread}"
    .top.o.others add cascade -label "menu misc" -menu .top.o.others.ms
    menu .top.o.others.ms
    .top.o.others.ms add command -label "pwd" \
	-command "put_extended {pwd}"
    .top.o.others.ms add command -label "cd" \
	-command "put_extended {cd}"
    .top.o.others.ms add command -label "mkdir" \
	-command "put_extended {mkdir}"
    .top.o.others.ms add separator
    .top.o.others.ms add command -label "rmail" \
	-command "put_extended {rmail}"
    .top.o.others.ms add command -label "motd" \
	-command "put_extended {motd}"
    
    menubutton .top.help -text "Info"  -menu .top.help.m -bd 1 \
	-relief raised -padx 5 -pady 3
    menu .top.help.m
    .top.help.m add cascade -label "nn-tk Help" -menu .top.help.m.n
    menu .top.help.m.n
    .top.help.m.n add command -label "description" \
	-command "put_extended {help nn-tk}"
    .top.help.m.n add command -label "main window" \
	-command "put_extended {help nn-tk-main}"
    .top.help.m.n add command -label "group list" \
	-command "put_extended {help nn-tk-groups}"
    .top.help.m.n add command -label "modify panel" \
	-command "put_extended {help nn-tk-modify}"
    .top.help.m.n add command -label "TK-bindings" \
	-command "put_extended {help tk-bindings}"
    .top.help.m.n add command -label "options" \
	-command "put_extended {help options}"
    .top.help.m add cascade -label "nn Help" -menu .top.help.m.h
    menu .top.help.m.h
    .top.help.m.h add command -label "Help" -command "put_extended {help}"
    .top.help.m.h add command -label "attr" \
	-command "put_extended {help attr}"
    .top.help.m.h add command -label "commands" \
	-command "put_extended {help commands}"
    .top.help.m.h add command -label "extended" \
	-command "put_extended {help extended}"
    .top.help.m.h add command -label "map" -command "put_extended {help map}"
    .top.help.m.h add command -label "menu mode" \
	-command "put_extended {help menu}"
    .top.help.m.h add command -label "more mode" \
	-command "put_extended {help more}"
    .top.help.m.h add command -label "set variable" -command "put_extended {help set}"
    .top.help.m.h add command -label "show variable" \
	-command "put_extended {help show}"
    .top.help.m.h add command -label "sort" \
	-command "put_extended {help sort}"
    .top.help.m.h add command -label "variables" \
	-command "put_extended {help variables}"
    .top.help.m.h add command -label "nntp" \
	-command "put_extended {help nntp}"
    .top.help.m add separator
    .top.help.m add cascade -label "show info" -menu .top.help.m.sh
    menu .top.help.m.sh
    .top.help.m.sh add command -label "set" \
	-command "put_extended {set}"
    .top.help.m.sh add command -label "set all" \
	-command "put_extended {set all}"
    .top.help.m.sh add separator
    .top.help.m.sh add command -label "kill" \
	-command "put_extended {show kill}"
    .top.help.m.sh add separator
    .top.help.m.sh add command -label "groups" \
	-command "put_extended {show groups}"
    .top.help.m.sh add command -label "groups all" \
	-command "put_extended {show groups all}"
    .top.help.m.sh add command -label "groups subscr" \
	-command "put_extended {show groups subscr}"
    .top.help.m.sh add command -label "groups total" \
	-command "put_extended {show groups total}"
    .top.help.m.sh add command -label "groups unsub" \
	-command "put_extended {show groups unsub}"
    .top.help.m.sh add separator
    .top.help.m.sh add command -label "map" \
	-command "put_extended {show map}"
    .top.help.m.sh add command -label "map key" \
	-command "put_extended {show map key}"
    .top.help.m.sh add command -label "map menu" \
	-command "put_extended {show map menu}"
    .top.help.m.sh add command -label "map show" \
	-command "put_extended {show map show}"
    .top.help.m.sh add command -label "map #" \
	-command "put_extended {show map #}"
    .top.help.m.sh add separator
    .top.help.m.sh add command -label "rc" \
	-command "put_extended {show rc}"
    if {[info procs Sedit_ComposeUI] != ""} {
	.top.help.m add command -label "Compose key sequences" \
	    -command "mksedit_compose"
    } else {
	.top.help.m add command -label "Edit Character compose" \
	    -command "mksedit_compose" -state disabled
    }
    .top.help.m add separator
    .top.help.m add command -label "Man" -command "put_extended {man}"
    
    menubutton .top.macro -text "USER"  -menu .top.macro.m -bd 1 \
	-relief raised -padx 5 -pady 3
    menu .top.macro.m
    user_menu .top.macro.m
    
    menubutton .top.option -text "Setup" -menu .top.option.m -bd 1 \
	-relief raised -padx 5 -pady 3
    menu .top.option.m
    .top.option.m add command -label "Save Window geometry" \
	-command "config_save_geom"
    .top.option.m add separator
    if { $has_exmh} {
	.top.option.m add command -label "Key bindings" \
	    -command "mksedit"
	.top.option.m add command -label "Exmh options" \
	    -command "menu_sedit"
    } else {
	.top.option.m add command -label "Key bindings" \
	    -command "mksedit" -state disabled
	.top.option.m add command -label "Exmh options" \
	    -command "Preferences_Dialog" -state disabled
    }	
    .top.option.m add separator
    .top.option.m add command -label "NN-TK General" -command {opt_Make vars_misc options options_fill $vars_misc "NN-TK general options"}
    .top.option.m add command -label "NN-TK Group List" -command {opt_Make vars_group options options_fill $vars_group "NN-TK group list options"}
    .top.option.m add command -label "NN-TK Group Cascade Menu" -command {opt_Make vars_cascade options options_fill $vars_cascade "NN-TK group menu options"}
    .top.option.m add separator

    .top.option.m add cascade -label "NN Variables" -menu .top.option.m.v
    menu .top.option.m.v

    set label [option get .top.option labels {} ]
    set i 0
    foreach m [option get .top.option entrylist {} ] {
	.top.option.m.v add command -label [lindex $label $i] \
	    -command "variables_Make $m \"[lindex $label $i]\""
	incr i
    }
    .top.option.m.v add separator
    .top.option.m.v add command -label "(modified)" \
	-command "variables_Make m modified"
    .top.option.m.v add command -label "(all)" \
	-command "variables_Make a all"
    .top.option.m add separator

    global userc_v
    set userc_v(0) "User defined menu entries"
    set userc_v(1) "Command"
    set userc_v(2) "Description"
    .top.option.m add command -label "USER Command Menu" \
	-command "table_Make user userc_v .top.macro.m com_user des_user"
    .top.option.m add separator

    global color_v
    set color_v(0) "Color Group List"
    set color_v(1) "Match string"
    set color_v(2) "Color"
    .top.option.m add command -label "Color Group List" \
	-command "table_Make color color_v .groups.list col_pattern col_name"

    button .top.qu -text "quit"  -command "put_funct \{$token(K_QUIT)\} m" \
	-width 8 -padx 0 -pady 2


    pack  .top.m  .top.option   .top.a .top.o .top.f .top.macro \
	.top.help   -side left -padx 8 -pady 2 \
	-in .top.x -side left
    pack .top.pic -side left -anchor w

    button .top.hlp  -text "Help" -command "put_extended {help nn-tk-main}"
    pack .top.hlp -side right

    pack .top.qu -padx 12 -side right

    set color_bg [.top cget -background]
    button .top.cancel -text "C" -command "nntp_abort" \
	-disabledforeground $color_bg -state disabled \
	-borderwidth 0 -cursor left_ptr
    pack .top.cancel -side right

    pack .top.x  -side left -padx 8
}

proc nntp_active {} {
    .top.cancel configure -background red -foreground white -state normal \
	-borderwidth 3

    . configure -cursor watch
    .more.t configure -cursor watch
    .menu.article configure -cursor watch
    .groups.list configure -cursor watch
    update
}

proc nntp_inactive {} {
    
    after cancel nntp_active

    if {[.top.cancel cget -state] != "disabled"} {
     set color_bg [.top cget -background ]

    .top.cancel configure -background $color_bg -foreground $color_bg\
	-state disabled -borderwidth 0

    . configure -cursor left_ptr
    .more.t configure -cursor left_ptr
    .menu.article configure -cursor left_ptr
    .groups.list configure -cursor left_ptr
    }
}

proc nntp_started {} {
    global Config

    if {$Config(cprompt_delay) == 0} {
	nntp_active
    } else {
	after [expr $Config(cprompt_delay)*1000] nntp_active
    }
}

proc middle_buttons {} {
    global token

    if {[winfo exists .middle]} {
	destroy .middle
    }
    frame .middle -borderwidth 2  -relief ridge
    button .middle.pg -text "prev G"  \
	-command "put_funct $token(K_PREVIOUS) m" -width 8 -padx 0 -pady 2	
    button .middle.ps -text " < "  \
	-command "put_funct $token(K_PREV_PAGE) m" -width 3 -padx 0 -pady 2
    button .middle.bmenu -text "="  \
	-command "put_funct $token(K_BACK_TO_MENU)" -width 3 -padx 0 -pady 2
    button .middle.ns -text " > "  \
	-command "put_funct $token(K_NEXT_PAGE) m" -width 3 -padx 0 -pady 2
    button .middle.nread -text "read/skip"  \
	-command "put_funct $token(K_READ_GROUP_UPDATE)" -width 10 -padx 0 -pady 2
    button .middle.ng -text "next G"  \
	-command "put_funct $token(K_NEXT_GROUP_NO_UPDATE) m" -width 8 -padx 0 -pady 2
    button .middle.page -text "PAGE"  \
	-command "put_funct $token(K_CONTINUE)" -width 14 -padx 0 -pady 2
    
    pack .middle.pg  .middle.ps  .middle.bmenu .middle.ns  .middle.nread  \
	.middle.ng .middle.page -side left -padx 8 -pady 2
}

#
#	Article menu
#

proc menu_choose {scr x y} {
    global ev_input EV_SELECT_E mdrag_id
    global chp 

    scan [$scr index @99999,$y] %d.%d yc xc 

#    	puts stderr "$x $y - $xc $yc - $chp"
    set resced 1
    
    if {$y >= [winfo height $scr]} {
	$scr yview scroll 2 units
    } elseif {$y < 0} {
	$scr yview scroll -2 units
    } else {
	set resced 0
    }

    if {$yc != $chp } {
	ev_type_menu 
	if {$yc > $chp} {
	    set n 1 
	} else {
	    set n -1
	}
	set ychk [expr $yc+$n]
	for {set i [expr $chp+$n]} {$i != $ychk} {incr i $n} {
	    scan [$scr index $i.99999] %d.%d tyc txc
	    if {$txc > 0} {
		rec_c $EV_SELECT_E $i
	    }
	}
	set chp $yc
    }
    after cancel $mdrag_id
    if {$resced} {
	set mdrag_id [after 100 "menu_choose $scr 1 $y"]
    }	
}

proc menu_choose-s {scr x y funct} {
    global ev_input ev_type 
    global chp cur_menu_pos

    set cur_menu_pos [lindex [$scr yview] 0]

    set p [$scr index @9999,$y]
    scan $p %d.%d yc xc
    if {$xc == 0} {
	return
    }
#    	puts stderr "$x $y - $xc $yc - $chp"
    ev_type_menu
    rec_c $funct $yc
    set chp $yc
}

proc menu_nextgroup {group} {
    global m_newgroup

    more_clear
    thread_clear
    wm iconname . $group
    wm title . nn:$group
    set m_newgroup 2
}

  
proc menu_min {} {
    global Config m_newgroup group_menu_length
    global cur_menu_pos

    if {$Config(menu_max) == $Config(menu_min)} {
	return
    }

    if {$m_newgroup == 1} {
	if {$group_menu_length < $Config(menu_min)} {
	    set mmin $group_menu_length
	} else {
	    set mmin $Config(menu_min)
	}
	menu_resize $mmin
	set m_newgroup 0
    }
}

proc menu_max {l} {
    global Config group_menu_length m_newgroup

    if {$Config(menu_max) == $Config(menu_min)} {
	return
    }

    if {$m_newgroup == 2} {
	set ht [lindex [.menu.article configure -height] 4]
	if {$ht > $l} {
	    set l $ht
	}

	if {$group_menu_length < $Config(menu_max)} {
	    set mmax $group_menu_length
	} else {
	    set mmax $Config(menu_max)
	}

	if {$l < $mmax} {
	    menu_resize $l
	} else {
	    menu_resize $mmax
	}
    }
    set m_newgroup 1
}

proc menu_resize {l} {
    global Config menu_extended

    .menu.article configure -height $l
    .menu.index configure -height $l

    if {$menu_extended > 0} {
	set n [expr $menu_extended +1]
	.menu.article delete "end - $n chars" end
	set menu_extended 0
    }
    m_scrollbar .menu.article .menu.sx $Config(horizontal_scrollbars)
}

proc m_scrollbar {w s conf} {

    scan [$w xview] "%f %f" stx fnx
    set xv [expr $fnx - $stx]
    if {[winfo ismapped $s]} {
	if {((($xv == 1.0) && ($conf != 2)) || ($conf == 0))} {
		pack forget $s
	} 
    } else {
	if {((($xv < 1.0) && ($conf != 0)) || ($conf == 2))} {
		pack $s -side bottom -fill x 
	}	    
    }
}   

proc menu_clear {} {
    global menu_extended

    .menu.article delete 0.0 end
    set menu_extended 0
}

proc menu_clear_partial {l} {
    global menu_extended

    .menu.article delete $l.0 end
    set menu_extended 0
}

proc menu_pos {y} {
    global cur_menu_pos

    set t [.menu.sy get]
    scan $t "%f %f" first last

    set lines [.menu.article index end]
    set yl [expr $lines*$last]
    set yf [expr $lines*$first]
#    	    puts "lines=$lines first=$first last=$last yl=$yl yf=$yf y=$y"
    if {$cur_menu_pos == 0} {
	if {($y > $yl) || \
		($y < $yf)} {
	    .menu.article yview [expr $y-2]
	}
    } else {
	.menu.article yview moveto $cur_menu_pos
	set cur_menu_pos 0
    }
}

proc menu_mark {y} {
    .menu.article tag remove mark 0.0 end
    .menu.article tag remove select $y.0 [expr $y+1].0
    .menu.article tag add mark $y.0 [expr $y+1].0
    menu_pos $y
}

proc menu_inverse {y} {
    .menu.article tag add select $y.0 [expr $y+1].0
}

proc menu_under {y} {
    .menu.article tag add under $y.0 [expr $y+1].0
}

proc menu_p_inverse {y xs xf} {
    .menu.article tag add select $y.0 [expr $y+1].0
}

proc menu_normal {y} {
    .menu.article tag remove select $y.0 [expr $y+1].0
    .menu.article tag remove under $y.0 [expr $y+1].0
}

proc menu_ent { yp xp} {
    global menu_ent_t 
    set end [.menu.article index end]

    scan $end %d.%d yl dd
    incr yl -1
    if {$yp > $yl} {
	.menu.article insert $end "\n"
    }
    .menu.article delete $yp.0 "$yp.0 lineend"
    .menu.article insert $yp.0 $menu_ent_t
    .menu.article tag remove fix $yp.0 "$yp.0 lineend"
    .menu.article tag add fix $yp.0 $yp.$xp
    .menu.article tag add indx $yp.0 $yp.1
}

proc menu_fill { yp xp} {
    global menu_ent_t 

    .menu.article insert end $menu_ent_t
    .menu.article tag add fix $yp.0 $yp.$xp
    .menu.article tag add indx $yp.0 $yp.1
}

proc set_read_mode {{c " "}} {
    global read_mode
    set read_mode $c
}

# changes the state of buttons dependent on menu or article modes
proc set_menu_mode {c} {
    global menu_mode has_exmh

    set menu_mode $c
    if {$menu_mode == "m"} {
	button_mode .middle.bmenu disabled
	button_mode .bottom.bns disabled
	button_mode .bottom.bp disabled
	button_mode .bottom.next disabled
	.middle.nread configure -text "read/skip"
	.top.a.art  entryconfigure 8 -state disabled
	.top.a.art.a entryconfigure 1 -state disabled
	.top.a.art.a entryconfigure 2 -state disabled
	.top.a.art.a entryconfigure 3 -state disabled
	.top.o.others entryconfigure 2 -state   normal
	.top.o.others entryconfigure 3 -state  normal
    } else {
	button_mode .middle.bmenu normal
	button_mode .bottom.bns normal
	button_mode .bottom.bp normal
	button_mode .bottom.next normal
	.middle.nread configure -text "skip G"
	.top.a.art entryconfigure 8 -state  normal
	if {$has_exmh} {
	    .top.a.art.a entryconfigure 1 -state normal
	    .top.a.art.a entryconfigure 2 -state normal
	    .top.a.art.a entryconfigure 3 -state normal
	}
	.top.o.others entryconfigure 2 -state  disabled
	.top.o.others entryconfigure 3 -state  disabled
    }
}

proc menu_Make {} {
    global color_bd color_bs color_w monochrome EV_SELECT EV_SELECT_C EV_SELECT_E EV_SELECT_C_E
    global menu_extended mdrag_id
    set menu_extended 0
    set mdrag_id 0

    frame .menu

    text .menu.article -relief raised -bd 2 \
	-cursor left_ptr -width 80\
	-wrap none -yscrollcommand ".menu.sy set" -xscrollcommand ".menu.sx set"

    bind .menu.article <B1-Motion> "menu_choose .menu.article %x %y; break"
    bind .menu.article <Button-1> "menu_choose-s .menu.article %x %y $EV_SELECT_E; break"
    bind .menu.article <B1-Leave> "break"
    bind .menu.article <B1-Enter> "break"
    bind .menu.article <ButtonRelease-1> {after cancel $mdrag_id}
    bind .menu.article <ButtonRelease-2> "break"
    bind .menu.article <Button-3> "menu_choose-s .menu.article %x %y $EV_SELECT_C_E; break"
    bindtags .menu.article {.menu.article Text . all}
	
    text_bindings .menu.article 

    .menu.article tag configure fix \
	-font [option get .menu.article fixed_font {} ]

    .menu.article tag configure indx \
	-borderwidth 2 -background \
	$color_bd -font [option get .menu.article label_font {} ] 
    if {$monochrome == 1} {
	.menu.article tag configure select -background black -foreground white 
	.menu.article tag configure mark -bgstipple gray25 -background black
    } else {
	.menu.article tag configure select -background  $color_bs -relief raised -borderwidth 1
	.menu.article tag configure mark -background  $color_bd -relief raised -borderwidth 1
    }
    .menu.article tag configure under -underline 1
    scrollbar .menu.sy  -command ".menu.article yview"
    scrollbar .menu.sx  -command ".menu.article xview"  -orient horiz 
	
    text .menu.index -relief raised -bd 2 -width 1 -background \
	$color_bd -font [option get .menu.article prompt_font {} ]
    .menu.index insert end "a\nb\nc\nd\ne\nf\ng\nh\ni\nj\nk\nl\nm\nn\no\np\nq\nr\ns\nt\nu\nv\nw\nx\ny\nz\n0\n1\n2\n3\n4\n5\n6\n7\n8\n9"
    pack .menu.index -side left -anchor n

    text .menu-g -relief raised -bd 2  \
	-height 1 \
    	-font [option get .menu.article prompt_font {} ]
    .menu-g tag configure pcolor  -foreground  \
	[option get .menu-g prompt_color {}]

    text .menu-pr -relief raised -bd 2  \
	-height 1 -wrap none\
    	-font [option get .menu.article prompt_font {} ]
    bind .menu-pr <Button-1> break
    bind .menu-pr <ButtonRelease-2> break
    bind .menu-pr <2> prompt_insert
    .menu-pr tag configure pcolor  -foreground  \
	[option get .menu-pr prompt_color {}] -relief sunken

    .menu.article tag raise indx

    pack .menu.sy -side right -fill y
    pack .menu.article -side top -fill x
}

proc menu_handle_Make {w} {
    global color_bd

    frame $w-handle -height 12 -width 12 -relief raised -borderwidth 2 \
	-cursor double_arrow -background $color_bd
    place $w-handle -relx 0.95 -y -6 -in $w

    bind $w-handle <Button-1> "menu_drag $w 0"
    bind $w-handle <B1-Motion> "menu_drag $w %y"
    bind $w-handle <ButtonRelease-1> "menu_drag_resize $w %y 1"
    bind $w-handle <Button-2> "menu_drag $w 0"
    bind $w-handle <B2-Motion> "menu_drag $w %y"
    bind $w-handle <ButtonRelease-2> "menu_drag_resize $w %y 2"
    frame $w-bar -width 800 -height 3 -bg red
}

proc menu_drag {w y} {
    place $w-bar -y [top_y  .menu-pr $y] -x [top_x  .menu-pr 0] -anchor w
}
    
proc menu_drag_resize {w y b} {
    global menu_mode Config

    set curr [top_y  .menu-pr $y]
    set menu_top [top_y .menu.article 0]
    set menu_height [winfo height .menu.article]
    set menu_chars [lindex [.menu.article configure -height] 4]
    set new_size [expr (($curr-$menu_top)*$menu_chars)/$menu_height]

    .menu.article configure -height $new_size
    .menu.index configure -height $new_size
    if {$b == 2} {
	if {$menu_mode == "m"} {
	    msg_tmp "Setting menu_max"
	    set Config(menu_max) $new_size
	} else {
	    msg_tmp "Setting menu_min"
	    set Config(menu_min) $new_size
	}
    }
    place  forget $w-bar
}
 
proc menu_where {} {
     set t [.menu.sy get]
    scan $t "%f %f" first last
    set lines [.menu.article index end]
    set page [expr $first*$lines] 
    return $page
}

proc menu_chop {} {
#note display problem with last line
    if {[.menu.article get  "end - 1 chars"] == "\n"} {
	.menu.article delete "end - 1 chars"
    }
}

#               return 1 if not at the begining/end in menu display
proc menu_page {dir unit} {
    global menu_extended

    set t [.menu.sy get]
    #      compensate for the fact that the bottom line
    #      nolonger scrolls past the bottom of the window
    scan $t "%f %f" first last
    set fraction [expr $last-$first]
    set lines [.menu.article index end]
    set page [expr $fraction*$lines]
    set remain [expr (1-$last)*$lines]
#    	puts "lines=$lines page=$page remain=$remain t=$t"
    if {"$dir" == "+" && !$menu_extended && ($page > $remain) && ($fraction != 1.0)} {
	set pad [expr int($page-$remain)]
	.menu.article insert end [string range "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n" 1 $pad]
	set menu_extended $pad
    }
    if {("$dir" == "-" && $first<=0.0) || ("$dir" == "+" && $last>=1.0)} {
	return 0
    }
    set sign [expr ("$dir"=="+"?"":"-")]
    switch -- $unit {
	line	{.menu.article yview scroll ${sign}1 units}
	half	{.menu.article yview scroll ${sign}[expr int($page/2+1)] units}
	page	{.menu.article yview scroll ${sign}1 pages
	         .menu.article yview scroll ${sign}2 units}
	all	{if {"$dir" == "+"} {
			.menu.article yview moveto [expr 1.0-($last-$first)]
		 } else {
			.menu.article yview moveto 0.0
		 }
		}
    }
    return 1
}

proc info_reset {} {
    global pr_pt

    set pr_pt 0
}

proc info_msg {txt { level normal }} {
    global pr_pt

#    puts "$level $pr_pt $txt"
    if {$pr_pt == 0} {
	.menu-pr insert end  "     "
	set pr_pt [.menu-pr index "end - 1 chars"]
    }

    .menu-pr delete $pr_pt end
    .menu-pr insert end "$txt" pcolor 
    update idletasks
}

proc mprompt_msg {txt} {
    global Config g_pt

    if {$g_pt == 0} {
	.menu-g insert end  "     "
	set g_pt [.menu-g index "end - 1 chars"]
    } else {
	.menu-g delete $g_pt end
    }
	
    .menu-g insert end "$txt" pcolor 
}
    
proc mprompt_clear {} {
    global Config g_pt

    if {$g_pt != 0} {
  	.menu-g delete $g_pt end
    }
}

proc pprompt_msg {txt } {
    global Config pr_pt

    if {$Config(compressed_prompt) == 0} return

    if {$pr_pt == 0} {
	.menu-pr insert end  "     "
	set pr_pt [.menu-pr index "end - 1 chars"]
    }
    .menu-pr insert end "$txt" pcolor 
}

proc pprompt_delc {} {
    global Config pr_pt

    if {$Config(compressed_prompt) == 0} return

    if {$pr_pt != 0} {
	.menu-pr delete "end -2 chars"
    }
}

proc pprompt_clear {} {
    global Config pr_pt

    if {$Config(compressed_prompt) == 0} return

    if {$pr_pt != 0} {
	.menu-pr delete $pr_pt end
    }
}

proc pprompt_clrline {pos} {
    global Config pr_pt

    if {$Config(compressed_prompt) == 0} return

    if {$pr_pt != 0} {
	scan $pr_pt 1.%d base
	.menu-pr delete "$pos +$base chars" end
    }
}

#
#	Article display
#
proc more_all {state} {
    if {$state == "normal"} {
	pack .bottom.all -before .bottom.search -side left -padx 5
    } else {
	pack forget .bottom.all
    }
}

proc more_bar {} {
    global Config

    m_scrollbar .more.t .more.sx $Config(horizontal_scrollbars)
}

proc more_font {} {
    global Config

    #	packer strangeness
    scan [.menu.article configure -height] "-height height Height %d %d" x ht

    if {$Config(mono_font)} {
	.more.t configure -font [option get .more fix_font {} ]
    } else {
	.more.t configure -font [option get .more  var_font {} ]
    }
    more_bar
}

proc more_b {} {
    global more_l_t
    .more.t insert end $more_l_t
    .more.t tag add bold "end linestart" "end -2 chars"
}

proc more_l {} {
    global more_l_t
    .more.t insert end $more_l_t
}

proc more_clear {} {
    global more_pos str_old more_extended

    if {[lindex [.more.t configure -state] 4] == "disabled"} {
	clear_mime
    }
    .more.t configure -background white
    set more_pos 1
    .more.t delete 0.0 end
    set str_old ""
    set more_extended 0
}

#               return 1 if not at the begining/end in article display
proc page {dir unit} {
    global more_extended

    set t [.more.sv get]
    #      compensate for the fact that the bottom line
    #      nolonger scrolls past the bottom of the window
    scan $t "%f %f" first last
    set lines [.more.t index end]
    set page [expr ($last-$first)*$lines]
    set remain [expr (1-$last)*$lines+2]
    #	puts "lines=$lines page=$page remain=$remain"
    if {"$dir" == "+" && !$more_extended && ($page > $remain)} {
	set pad [expr int($page-$remain)]
	#	    puts "pad=$pad"
	.more.t insert end [string range "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n" 1 $pad]
	set more_extended $pad
    }
    if {("$dir" == "-" && $first<=0.0) || ("$dir" == "+" && $last>=1.0)} {
	return 0
    }
    set sign [expr ("$dir"=="+"?"":"-")]
    switch -- $unit {
	line	{.more.t yview scroll ${sign}1 units}
	half	{.more.t yview scroll ${sign}[expr int($page/2+1)] units}
	page	{.more.t yview scroll ${sign}1 pages}
	all	{if {"$dir" == "+"} {
			.more.t yview moveto [expr 1.0-($last-$first)]
		 } else {
			.more.t yview moveto 0.0
		 }
		}
    }
    return 1
}

#              Next article or group
proc do_next {} {
    global token
    put_funct $token(K_NEXT_ARTICLE)
}

#              Prev article or group
proc do_prev {} {
    global token
    put_funct $token(K_BACK_ARTICLE)
}

proc more-search {} {
    global more_pos str_old 
    set t [.more.sv get]
    scan $t "%f %f" f l
    set lines [.more.t index end]
    set first [expr round($f*$lines)]
    set last [expr round($l*$lines)]
    set win [expr round(($l-$f)*$lines)]

    set str [.bottom.search.txt get]
    if {$str_old != $str} {
	.more.t tag remove inv 0.0 end
	set str_old $str
	set more_pos $first
    }

    if {$more_pos < $first || $more_pos > [expr $last+1]} {
	set more_pos  [expr $first]
    }

    .more.t tag configure inv -underline 1
    scan [.more.t index end] %d nl
    set ln [string length $str]
    set str [string tolower $str]

    set first_match 1
    set bound $nl
    set found 0
    for {set i $more_pos} {$i <= $nl} {incr i} {
	set line [string tolower [.more.t get $i.0 $i.1000]]

	if {[set n [string first $str $line]] != -1} {
	    set offset 0
	    set found 1

	    while {$n >= 0} {
	        .more.t tag add inv $i.[expr $n+$offset] $i.[expr $n+$ln+$offset]
		set offset [expr $n+$ln+$offset]
		set n [string first $str [string range $line $offset 1000]]
	        if {$first_match} {
		    .more.t yview  [expr $i-4]
		    set bound [expr $i+$win-4]
		    set first_match 0
	        }
	    }
	}
    	if {$i >= $bound} {
	    set more_pos  $i
	    break
        }
    }
    if {!$found} {
	msg_tmp "String not found"
    }
}

proc more-search-b {} {
    global more_pos str_old 
    set t [.more.sv get]

    scan $t "%f %f" f l
    set lines [.more.t index end]
    set first [expr round($f*$lines)]
    set last [expr round($l*$lines)]
    set win [expr round(($l-$f)*$lines)]

    set str [.bottom.search.txt get]
    if {$str_old != $str} {
	.more.t tag remove inv 0.0 end
	set str_old $str
        set more_pos $last
    }
    if {[expr $more_pos-1] < $first || $more_pos > $last} {
        set more_pos  [expr $first]
    }

    .more.t tag configure inv -underline 1
    scan [.more.t index end] %d nl
    set ln [string length $str]
    set str [string tolower $str]

    set first_match 1
    set bound 0
    set found 0
    for {set i $more_pos} {$i > 0} {set i [expr $i-1]} {
	set line [string tolower [.more.t get $i.0 $i.1000]]

	if {[set n [string first $str $line]] != -1} {
	    set offset 0
	    set found 1
	    while {$n >= 0} {
	        .more.t tag add inv $i.[expr $n+$offset] $i.[expr $n+$ln+$offset]
	        set offset [expr $n+$ln+$offset]
	        set n [string first $str [string range $line $offset 1000]]
                if {$first_match} {
                    .more.t yview  [expr $i-$win+3]
                    set bound [expr $i-$win+3]
                    set first_match 0
                }
	    }
	}
    	if {$i <= $bound} {
	    set more_pos $i
	    break
    	}
    }
    if {!$found} {
	msg_tmp "String not found"
    }
}

proc more-srch {} {
    global nn_x_dir

    frame .bottom.search

    image create bitmap down -file $nn_x_dir/tcl/down.xbm
    image create bitmap up -file $nn_x_dir/tcl/up.xbm

    button .bottom.search.bt -image down  -command "more-search" -bd 2 \
	-relief raised  -padx 0 -pady 2
    button .bottom.search.bf -image up -command "more-search-b" -bd 2 \
	-relief raised -padx 0 -pady 2
    entry .bottom.search.txt -relief sunken -width 15
    pack .bottom.search.bt .bottom.search.txt  .bottom.search.bf -side left
    bind .bottom.search.txt <Return> "more-search"
}

proc bottom_buttons {} {
    global mono_font token
    
    frame .bottom -borderwidth 2  -relief ridge
    checkbutton .bottom.font -variable Config(mono_font) -text "Mono" \
	-command "more_font"  -bd 2 -relief raised -width 7
    .bottom.font configure  -pady 4

    button .bottom.bns -text "n-subj"  \
	-command "put_funct $token(K_NEXT_SUBJECT)" \
	-width 7 -padx 0 -pady 2
    button .bottom.all -text "All"  \
	-command "do_more_lines" -width 5 -padx 0 -pady 2
    button .bottom.bp -text "prev"  -command "do_prev" -width 7 -padx 0 -pady 2
    button .bottom.next -text "next"  -command "do_next" -width 7 -padx 0 -pady 2
    button .bottom.page -text "PAGE"  -command "put_funct $token(K_CONTINUE)" -width 10 -padx 0 -pady 2
    more-srch
    
    pack .bottom.search -side left -padx 5
    pack   .bottom.font .bottom.bns  .bottom.bp .bottom.next \
	.bottom.page -side left -padx 3 -pady 2
}

proc do_more_lines {} {
    global token
    more_lines 100000
    put_funct $token(K_REDRAW)
}

proc more_ff {} {
    .more.t insert end "\n\n"
    .more.t tag add ff  "end - 2 chars" "end - 1 chars"
}

proc more_Make {} {
    global color_w Config has_exmh

    frame .more

    if {$Config(mono_font)} {
	set font [option get .more fix_font {} ]	
    } else {
	set font [option get .more var_font {} ]	
    }

    if {$has_exmh} {
	Widget_Text .more 1 -relief raised -bd 2  \
	    -font $font -wrap none -xscrollcommand ".more.sx set"
    } else {
	frame .more.f
        text .more.t -relief raised -bd 2 -yscrollcommand ".more.sv set" \
	    -height 1 -wrap none -cursor left_ptr -xscrollcommand ".more.sx set"\
	    -font $font -width 1
#	    -setgrid true
	pack  .more.t -side left -expand yes -fill both -in .more.f
	scrollbar .more.sv  -command ".more.t yview"
	
	pack .more.sv -side left -fill y -in .more.f
	pack .more.f -side top -expand yes -fill both
    }
    scrollbar .more.sx  -command ".more.t  xview"  -orient horiz 
    more_bar

    text_bindings .more.t
    bind .more.t <ButtonRelease-2> "break"

    more_tags

}

proc more_tags {} {
    global color_bd
    .more.t tag configure bold -font [option get .more bold_font {} ]
    .more.t tag configure ff  -relief raised -borderwidth 2 -background\
	$color_bd
}
proc main_Make {} {
    global Config nn_x_dir


    top_buttons
    pack  .top -side top -fill x
    menu_Make
    pack .menu-g .menu  -side top -fill x 
    pack .menu-pr -side top -fill x 
    middle_buttons
    more_Make
    pack  .more -side top -expand yes -fill both
    bottom_buttons
    pack  .bottom -side top


    if {$Config(middle_button_pos) == 2} {
	pack  .middle -side top -after .top
    } elseif {$Config(middle_button_pos) == 1} {
	pack  .middle -side top -after .menu-pr
    } else {
	pack  .middle -side top -after .more
    }
    if {($Config(separate_prompt) == 0) && ($Config(compressed_prompt) != 2)} {
	pack .prompt -side top -fill x
    }
    menu_handle_Make .menu-pr
}

