#include <linuxmt/config.h>
#include <linuxmt/types.h>
#include <arch/system.h>
#include <linuxmt/sched.h>

void taska();
void taskb();

__uint tnum, tnuma;
__uint s_cs, s_ds, s_taska;
extern __pregisters _reglasttask, _regnexttask;

void main()
{
	__u16 a;

	setup_arch();
	tnum = build_task();
	tnuma = build_task();
	CURRENT= &task[tnum];
	NEXT = &task[tnuma];
#asm
	mov bx, #_s_cs
	mov [bx], cs
	mov bx, #_s_ds
	mov [bx], ds
	mov bx, #_s_taska
	mov [bx], #_taska
#endasm
	task[tnuma].t_regs.ax = task[tnuma].t_regs.bx = task[tnuma].t_regs.cx = task[tnuma].t_regs.dx = 0;
	task[tnuma].t_regs.si = task[tnuma].t_regs.di = 0;
	task[tnuma].t_regs.ss = 0x8000;
	task[tnuma].t_regs.sp = task[tnuma].t_regs.bp = 0x0000;
	task[tnuma].t_regs.cs = s_cs;
	task[tnuma].t_regs.ds = s_ds;
	task[tnuma].t_regs.ip = s_taska;
	task[tnuma].t_regs.flags = 0x0206;
	load_regs(&task[tnuma]);
#asm
b:	mov ax, #0xe42
	int 0x10
#endasm
	NEXT = &task[tnuma]; 
#asm
	int #0x80
	jmp b
#endasm
}

void taska()
{
/* Print 'A' and switch tasks */
#asm
a:	mov ax, #0xe41
	int 0x10 
#endasm
	NEXT = &task[tnum];
#asm
	int #0x80
	jmp a
#endasm
}

void taskb()
{
#asm
b:	mov ax, #0xe43
	int 0x10
	jmp a
#endasm
}

