#include <linuxmt/types.h>
#include <linuxmt/sched.h>

/* These are various global defs used by the asm code */

/* First we start with some handy assembly code.  I love the way bcc
 * lets us do assembly and C in the same file without limits :)
 */

/* Taskswitch (int 0x80) : perform with interrupts *off*! 

   Basically, we save the registers, figure out what current is, and then
   go ahead and switch to the other task.

   This is only valid for stack-based __registers structures...
*/

#asm
_schedjump:
	push bp
	push es
	push ds
	push si
	push di
	push dx
	push cx
	push bx
	push ax
	xor ax, ax
	mov ds, ax
	mov ax, [0x300]
	mov ds, ax
	mov bx, #_CURRENT
	mov di, [bx]
	mov [di+2], sp
	mov [di+4], ss
	mov bx, #_NEXT
	mov si, [bx]
	mov sp, [si+2]
	mov ss, [si+4]
	mov bx, #_CURRENT
	mov [bx], si
	pop ax
	pop bx
	pop cx
	pop dx
	pop di
	pop si 
	pop ds
	pop es
	pop bp
	iret
#endasm

/* To get a dump of the registers, call this... I'd rather have the switch-code
 * simple and have helper-routines, since I want it small enough to work! */ 

void save_regs(task)
__ptask task;
{
#asm
	mov bp, sp
	mov si, sp 
	mov di, ss
	mov bx, 2[bp]
	mov sp, [bx+2]
	mov ss, [bx+4]
	add bx, #6
	mov cx, #11
saveloop:	pop ax
	mov [bx], ax
	inc bx
	inc bx
	loop saveloop
	mov [bx+2], sp
	mov sp, si
	mov ss, di	
	pop bp
#endasm
}

void load_regs(task)
__ptask task;
{
#asm
	mov bp, sp
	mov si, sp
	mov di, ss
	mov bx, 2[bp]
	mov sp, [bx+2]
	mov ss, [bx+4]
	mov cx, #12
	add bx, #28 
loadl:	mov ax, [bx]
	push ax
	dec bx
	dec bx
	loop loadl
	mov ss, di
	mov bx, 2[bp]
	mov [bx+2], sp
	mov sp, si
#endasm
}

void setup_arch()
{
#asm
	mov ah, #0xe
	mov al, #0x44
	xor bx, bx
	mov ax, ds
	mov ds, bx 
	mov [bx+0x200], #_schedjump
	mov [bx+0x202], cs
!	I hate using interrupt space, but 0x300-0x400 is going to be ts data
	mov [bx+0x300], ax
	mov ds, ax
#endasm
}

