#include <linuxmt/config.h>
#include <linuxmt/types.h>
#include <arch/system.h>
#include <linuxmt/sched.h>

void taska();
void taskb();

__uint tnum, tnuma;
__uint s_cs, s_ds, s_taska, s_sched;
extern __ptask _reglasttask, _regnexttask;

void main()
{
	__u16 a;
	__pregisters set; 
	int num;

/*	We set the scheduler up as task #0, and this as task #1 */

	setup_arch();
	tnum = build_task();
	tnuma = build_task();
	CURRENT= &task[0];
	NEXT = &task[1];
#asm
	mov bx, #_s_cs
	mov [bx], cs
	mov bx, #_s_ds
	mov [bx], ds
	mov bx, #_s_taska
	mov [bx], #_taska
	mov bx, #_s_sched
	mov [bx], #_schedule_task
#endasm
	for (num = 1; num < 4; num++) {
		set = &task[num].t_regs;
		set->ax = set->bx = set->cx = set->dx = 0;
		set->si = set->di = 0;
		set->sp = set->bp = 0x0000;
		set->cs = s_cs;
		set->ds = s_ds;
		set->flags = 0x0206;
	}
	task[1].t_regs.ss = 0x8c00;
	task[2].t_regs.ss = 0x8800;
	task[3].t_regs.ss = 0x8400;
	task[1].t_regs.ip = s_sched;
	task[2].t_regs.ip = s_taska;
	task[3].t_regs.ip = s_taska;
	CURRENT = &task[0];
	NEXT = &task[1];
	load_regs(NEXT);
	schedule();
	while (1) {
#asm
b:	mov ax, #0xe42
	int 0x10
#endasm
	schedule();
	};
}

void taska()
{
/* Print 'A' and switch tasks */
	while (1) {
#asm
a:		mov ax, #0xe41
		int 0x10 
#endasm
		schedule();
	};
}

void taskb()
{
#asm
b:	mov ax, #0xe43
	int 0x10
	jmp a
#endasm
}

