#ifndef LINUXMT_SCHED_H
#define LINUXMT_SCHED_H

#define MAX_TASKS 4

struct _task {
/* Executive stuff */
	__uint t_num;
	__registers t_regs;
	__pptr t_begcode, t_endcode, t_begdata, t_enddata, t_begstack, t_endstack; 
/* Scheduling + status variables */
	__s16 t_state;
	__uint t_counter, t_priority;	/* Valuable scheduling elements */
	__u16 t_flags; /* Not defined yet */
	__u16 t_errno; /* Last error */
};

#define TASK_RUNNING 0x1
#define TASK_STOPPED 0x2
#define TASK_UNINTER 0x4

/* We use typedefs to avoid using struct foobar (*) */
typedef struct _task __task;
typedef struct _task * __ptask;

__task task[MAX_TASKS];

extern __ptask CURRENT, NEXT;

_FUNCTION(__uint build_task, ());
_FUNCTION(__uint load_task, (__ptask ptask));
_FUNCTION(void schedule, ()); 

#endif
