/*
 * 	kernel/sched.c
 * 	(C) 1995 Chad Page 
 *	
 *	This is the main scheduler - hopefully simpler than Linux's at present.
 * 
 * 	We need to implement run-queues RSN, but first we just have to make
 * 	it *work*.  Of course, writing it would be a good start :)
 *
 */

#include <linuxmt/types.h>
#include <linuxmt/sched.h>

/* Bad hack - should be moved/pulled before 0.00.2ab */

__uint build_task()
{
	__task stask;

	stask.t_num = 0;
	stask.t_begcode = stask.t_endcode = stask.t_begdata = stask.t_enddata = 0;
	stask.t_begstack = stask.t_endstack = 0;
	/* This is the only one that matters right now */
	stask.t_regs.sp = stask.t_regs.ss = 0 ;
	stask.t_state = 0;
	stask.t_counter = stask.t_priority = 0;
	stask.t_flags = 0;
	stask.t_errno = 0;

	return load_task(&stask); 
}

/* This loads a task into memory - the task given can be deleted, as it is
 * now in the kernel data structure */

__uint load_task(ptask)
__ptask ptask;
{
	__uint count, found, b;

	found = 0;
	for (count = 1; (count < MAX_TASKS) && (found == 0); count++) {
		if ((task[count].t_num != count)) {
			found = count;
			/* This should be memcpy */
			for (b = 0; b < sizeof(__task); b++)
				((__u8 *)task[count])[b] = ((__u8 *)ptask[count])[b]; 
			task[count].t_num = count;
		}
	}			

	return found;
}	
