#include <linuxmt/config.h>
#include <linuxmt/types.h>
#include <arch/system.h>
#include <linuxmt/sched.h>

void taska();
void taskb();

__uint tnum;
extern __pregisters _reglasttask, _regnexttask;

void main()
{
	__u16 a;

	setup_arch();
	tnum = build_task();
	_reglasttask = &task[tnum].t_regs;
	tnum = build_task();
	_regnexttask = &task[tnum].t_regs;
#asm
	mov di, ss
	mov si, sp
	mov dx, #0x8000
	mov ss, dx
	xor sp, sp
	push #0x0206
	push cs
	push #_taska
	push #0x000
	push es 
	push ds
	push si
	push di
	push dx
	push cx
	push bx
	push ax
	mov bx, #__regnexttask
	mov [bx], sp
	mov [bx+2], ss
	mov sp, si
	mov ss, di
	int #0x80
b:	mov ax, #0xe42
	int 0x10
sw2:	mov bx, #__reglasttask
	mov cx, [bx]
	mov dx, [bx+2]
	mov bx, #__regnexttask
	mov [bx], cx
	mov [bx+2], dx
	nop
	int #0x80
	jmp b
#endasm
}

void taska()
{
/* Print 'A' and switch tasks */
#asm
a:	mov ax, #0xe41
	int 0x10 
switchtasks:	mov bx, #__reglasttask
	mov cx, [bx]
	mov dx, [bx+2]
	mov bx, #__regnexttask
	mov [bx], cx
	mov [bx+2], dx
	nop
	int #0x80
	jmp a
#endasm
}

void taskb()
{
#asm
b:	mov ax, #0xe43
	int 0x10
	jmp a
#endasm
}

