#include <linuxmt/types.h>
#include <linuxmt/sched.h>

/* These are various global defs used by the asm code */

/* First we start with some handy assembly code.  I love the way bcc
 * lets us do assembly and C in the same file without limits :)
 */

/* Taskswitch (int 0x42) : perform with interrupts *off*! 

   Basically, we save the registers, figure out what current is, and then
   go ahead and switch to the other task.

   This is only valid for stack-based __registers structures...
*/

__pregisters _reglasttask, _regnexttask;

#asm
_schedjump:
	push bp
	push es
	push ds
	push si
	push di
	push dx
	push cx
	push bx
	push ax
	xor ax, ax
	mov ds, ax
	mov ax, [0x300]
	mov ds, ax
	mov bx, #__reglasttask
	mov [bx], sp
	mov [bx+2], ss
	mov bx, #__regnexttask
	mov di, [bx]
	mov si, [bx+2]
	mov ss, si
	mov sp, di
	pop ax
	pop bx
	pop cx
	pop dx
	pop di
	pop si 
	pop ds
	pop es
	pop bp
	iret
#endasm

void setup_arch()
{
#asm
	mov ah, #0xe
	mov al, #0x44
	xor bx, bx
	mov ax, ds
	mov ds, bx 
	mov [bx+0x200], #_schedjump
	mov [bx+0x202], cs
	mov [bx+0x300], ax
	mov ds, ax
#endasm
}

	
