#!/bin/sh
set -x
CUR_DIR_NAME=`dirname "$0"`
CUR_DIR=`cd "$CUR_DIR_NAME" && pwd`
SERVICE_NAME=K4
RULESFILE="99-hid-${SERVICE_NAME}-device.rules"
VIDPIDS="072f:100d 25dd:2311 25dd:2211 25dd:2511 25dd:2611 2021:0002 2021:0012 2021:0102"
#NOTA: da lanciare gi con diritti root

# esegue lo script di installazione o rimozione vero e proprio
if test X$1 = X-d ; then
    rm 2>&1 >/dev/null -rf /etc/udev/rules.d/$RULESFILE
    rm 2>&1 >/dev/null -rf /usr/local/sbin/convert_token
    echo Uninstall: complete
else
    mkdir 2>&1 >/dev/null -p /usr/local/sbin/
    cp 2>&1 >/dev/null -f ${CUR_DIR}/../starthid.32.exe /usr/local/sbin/starthid.32.exe
    cp 2>&1 >/dev/null -f ${CUR_DIR}/../starthid.64.exe /usr/local/sbin/starthid.64.exe
    cp 2>&1 >/dev/null -f ${CUR_DIR}/../start_hid.bat /usr/local/sbin/start_hid_${SERVICE_NAME}
    cp 2>&1 >/dev/null -f ${CUR_DIR}/../starthid.32.exe.svc /usr/local/sbin/starthid.32.exe.svc
    cp 2>&1 >/dev/null -f ${CUR_DIR}/../starthid.64.exe.svc /usr/local/sbin/starthid.64.exe.svc
    #cp 2>&1 >/dev/null -f ${CUR_DIR}/../convert.32.exe /usr/local/sbin/convert.32.exe
    #cp 2>&1 >/dev/null -f ${CUR_DIR}/../convert.32.exe.svc /usr/local/sbin/convert.32.exe.svc
    #cp 2>&1 >/dev/null -f ${CUR_DIR}/../convert.64.exe /usr/local/sbin/convert.64.exe
    #cp 2>&1 >/dev/null -f ${CUR_DIR}/../convert.64.exe.svc /usr/local/sbin/convert.64.exe.svc
    cp 2>&1 >/dev/null -f ${CUR_DIR}/convert_token /usr/local/sbin/convert_token
    chmod -R +x /usr/local/sbin/
    for VIDPID in $VIDPIDS ; do
        echo $VIDPID | { IFS=: read VID PID
        echo 2>/dev/null 1>>/etc/udev/rules.d/$RULESFILE \
        "ATTRS{idVendor}==\"${VID}\", ATTRS{idProduct}==\"${PID}\", RUN+=\"/usr/local/sbin/convert_token\", MODE=\"0666\""
        }
    done
    for VIDPID in $VIDPIDS ; do
      USBS2=`lsusb | grep ${VIDPID} | sed -e 's/Bus \([0-9]\+\)/\1/' -e 's/Device \([0-9]\+\).*/\1/' | sed -e 's/\([0-9]*\) \([0-9]*\)/\1\/\2/'`
      for usb_hid in $USBS2 ; do ls -al /dev/bus/usb/${usb_hid}; chmod 0666 /dev/bus/usb/${usb_hid}; ls -al /dev/bus/usb/${usb_hid}; done
    done
    
    chmod 0666 /dev/usb/hiddev* 2>&1
    chmod 0666 /dev/hiddev*  2>&1
    echo Install: complete
fi
echo End.
