#!/bin/sh
set -ue

VIDPIDS='072f:100d|25DD:2311|25DD:2211|25DD:2511|25DD:2611|25DD:23B4|2021:0002|2021:0012|2021:0102'

TITLE="Autenticazione"
MSG="E' necessario correggere i diritti sul token al fine di poterlo
utilizzare. Digitare la password amministrativa per portare a
termine l'operazione:"
MSG_ERR="Non è stato possibile correggere i diritti. Il token
potrebbe non essere visibile al sistema."
MSG_PASSWORD="Password errata. Riprovare:"

EXEDIR="${0%/*}"
BITS="$(case "$(uname -m)" in x86_64) echo 64;; *) echo 32;; esac)"
EXE=starthid.${BITS}.exe
lsusb \
| sed -nr 's/^Bus (...) Device (...): ID ('"$VIDPIDS"').+$/\/dev\/bus\/usb\/\1\/\2/ip' \
| { cat; find /dev -iname 'hiddev*'; } \
| while read i; do
    [ $((0666 == ($(stat -c '%05a' "$i") & 0666))) -eq 0 ] && echo "$i"
done | {
    WRONG_MOD="$(cat)";
    if [ -z "$WRONG_MOD" ]; then
        exit # nessun file da correggere
    fi
    while true; do
        if ! PASSWORD="$(zenity --entry --hide-text \
                         --title "$TITLE" --text "$MSG")"; then
            zenity --error  --no-wrap --title "$TITLE" --text "$MSG_ERR" || true
            exit 0 # l'utente ha premuto cancel sulla richiesta di password
        fi
        if echo "$PASSWORD" | script -c 'sudo -S true'; then
            break # la password e' ok
        fi
        MSG="$MSG_PASSWORD"
    done
    echo "$PASSWORD" | script -c 'sudo -S sh -c '"'"'
        set -ue
        chmod ugo+rw '"$WRONG_MOD"' || true
        '"'${EXEDIR}/${EXE}'"' || true
    '"'" || true
    # successo
}
