#!/bin/sh
set -ue

TITLE="Autenticazione"
MSG="E' necessario digitare la password amministrativa
per portare a termine l'operazione:"
MSG_ERR="Non è stata possibile effettuare l'autenticazione"
MSG_PASSWORD="Password errata. Riprovare:"

EXEDIR="${0%/*}"
EXE=hutils/bin/ddna_diagnostics.exe

while true; do
    if ! PASSWORD="$(zenity --entry --hide-text \
                     --title "$TITLE" --text "$MSG")"; then
        zenity --error  --no-wrap --title "$TITLE" --text "$MSG_ERR" || true
        exit 0 # l'utente ha premuto cancel sulla richiesta di password
    fi
    if echo "$PASSWORD" | script -c 'sudo -S true'; then
        break # la password e' ok
    fi
    MSG="$MSG_PASSWORD"
done

echo "$PASSWORD" | script -c 'sudo -S sh -c '"'"'
    set -ue
    '"'${EXEDIR}/${EXE}'"' || true
'"'" || true
# successo
