/* $Id: word.h,v 1.1 2001/05/05 11:05:39 malekith Exp $ */

#ifndef YW_WORD_H
#define YW_WORD_H

#include <yw/types.h>
#include <yw/string.h>
#include <yw/map.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef enum {
	yw_bad_word = 0,	/* this being 0 can be relaied uppon */
	yw_key_word,
	yw_string_word,
	yw_int_word,
	yw_void_word,
	yw_bindata_word,
	yw_ptr_word		/* cannot be sent over the network */
} YwWordType;

typedef struct YwWord_struct YwWord;
struct YwWord_struct;

YwWord *yw_tag_find(YwWord *tags, const char *name);
/* return -1 on error */
int yw_tag_validate(YwWord *tags);

/* return -1 on error */
int yw_word_fetch_int(YwWord *w, int *res);
int yw_word_fetch_keyword(YwWord *w, const char **res);
int yw_word_fetch_string(YwWord *w, YwString **res);
int yw_word_fetch_ptr(YwWord *w, void **res);
int yw_word_fetch_void(YwWord *w);
int yw_word_fetch_bindata(YwWord *w, void **data, int *len);
int yw_word_fetch_mapped_keyword(YwWord *w, const YwMapEntry e[],
				 YwMapCache **cache, int *res);

YwWordType yw_word_type(YwWord *w);
YwWord *yw_word_next(YwWord *w);

YwWord *yw_word_new_int(int32_t);
YwWord *yw_word_new_keyword(const char *);
YwWord *yw_word_new_string(const YwString *);
YwWord *yw_word_new_ptr(void *);
YwWord *yw_word_new_void();
YwWord *yw_word_new_bad();
YwWord *yw_word_new_bindata(const void *, int);

YwWord *yw_word_copy_of(const YwWord *);
void yw_word_free(YwWord *);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* YW_WORD_H */
