/* $Id: util.h,v 1.9 2001/05/11 10:38:11 malekith Exp $ */

#ifndef YW_UTIL_H
#define YW_UTIL_H

#include <yw/types.h>
#include <yw/error.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <assert.h>

#define yw_assert(exp) assert(exp)
#define yw_halt() yw_assert(0)

/* cast to char* first, so we'll get warning when mixing
 * types */
#define YW_NEW(type) (type*)((char*)yw_malloc(sizeof(type)))
#define YW_NEW_0(type) (type*)((char*)yw_malloc_0(sizeof(type)))

#ifndef NULL
#define NULL ((void*)0)
#endif

/* util.c */
void yw_die(const char *msg);
void *yw_malloc(int size);
void *yw_malloc_0(int size);
void yw_free(void *ptr);
void *yw_realloc(void *ptr, int size);
void yw_sleep(int ms);

char *yw_strdup(const char*);
/* same as free(*dst); return *dst = strdup(src); */
char *yw_setstr(char **dst, const char *src);
/* concat NULL terminated string list */
char *yw_concat(const char *a1, ...);
char *yw_strstr(const char *s1, const char *s2);
char *yw_strchr(const char *s, int c);
void *yw_memmove(void *dest, const void *src, unsigned count);

/* md5.c */
/* md5 has to point to at least 16 byte long buffer */
void yw_count_md5(uint8_t *md5, const uint8_t *buf, int size);

/* byteswap n 32bit integers at ptr */
void yw_swap_bytes(uint32_t *ptr, int n);

/* convert.c */
extern const char *yw_default_encoding;
/* 0 for sucess */
int yw_convert( const char *src_enc, const void *src, int src_len,
		const char *dest_enc, void **dest, int *dest_len );

/* special encoding, for 32bit unicode in host byte order */
#define YW_UTF32_HE ("--UTF32-HOST-ENDIAN--")
		
/* locale_charset.c */
const char *yw_get_default_encoding(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* YW_UTIL_H */
