/* $Id: string.h,v 1.6 2001/05/23 08:46:02 malekith Exp $ */

#ifndef YW_STRING_H
#define YW_STRING_H

#include <yw/types.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef struct YwString_struct YwString;

struct YwString_struct {
	uint32_t *chars;
	int len;
};

/* In the following functions len == -1 means to search for null character.
   chars can be NULL if len == 0. */
int yw_string_assign_utf32(YwString *s, const uint32_t *chars, int len);
int yw_string_assign_utf16(YwString *s, const uint16_t *chars, int len);
int yw_string_assign_utf8(YwString *s, const uint8_t *chars, int len);
int yw_string_assign_cstring(YwString *s, const char *encoding,
			     const char *chars, int len);
    /* encoding == NULL means the default encoding. */
int yw_string_assign_string(YwString *s, const YwString *src);
int yw_string_assign_empty(YwString *s);
int yw_string_assign_one_char(YwString *s, uint32_t ch);
int yw_string_assign_n_chars(YwString *s, uint32_t ch, int n);

/* In the following functions chars is allocated using malloc. */
int yw_string_get_utf32(const YwString *s, uint32_t **chars, int *len);
int yw_string_get_utf16(const YwString *s, uint16_t **chars, int *len);
int yw_string_get_utf8(const YwString *s, uint8_t **chars, int *len);
int yw_string_get_cstring(const YwString *s, const char *encoding,
			  char **chars, int *len);
    /* encoding == NULL means the default encoding. */

int yw_string_idx(const YwString *s, uint32_t ch);
void yw_string_concat(YwString *s, const YwString *rest);
int yw_string_cmp(const YwString *s1, const YwString *s2);

void yw_string_free(YwString *);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* YW_STRING_H */
