/* $Id: sock.h,v 1.7 2001/05/04 11:04:32 malekith Exp $ */

#ifndef YW_SOCK_H
#define YW_SOCK_H

#include <yw/packet.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef struct YwConnection_struct YwConnection;
struct YwConnection_struct;

/* return codes described in <yw/error.h>, 0 (or YW_ERR_OK) is
 * general state for OK :> */

/* allocate memory for new connection, initialize it reasonably */
YwConnection *yw_conn_new();
/* set flag for connection */
int yw_conn_set_flag(YwConnection *conn, const char *name, const char *val);
/* open link to server */
int yw_conn_open(YwConnection *conn);
/* close & free */
void yw_conn_free(YwConnection *conn);
/* check connection state */
int yw_conn_state(YwConnection *conn);

int yw_conn_fd(YwConnection *conn);

int yw_conn_get_state(YwConnection *conn, const char **file, 
		      int *line, int *state);

/* connection flags:
 * flag		possible values	default
 * ZLIB		yes, no, maybe	maybe
 * CRYPT	yes, no, maybe	maybe
 * HOME		*		getenv("HOME")
 * AUTHORITY 	*		getenv("YAUTHORITY") || $HOME/.Yauthority
 * DISPLAY	*%*		getenv("YDISPLAY") || from AUTHORITY file
 * RANDFILE	*		getenv("RANDFILE") || /dev/urandom
 * RANDSEED	*		getenv("YRANDSEED") || ~/.Yrandseed
 */


YwPacket *yw_conn_recv(YwConnection *conn, int timeout);
YwPacket *yw_conn_recv_reply(YwConnection *conn, int timeout);
void yw_conn_send(YwConnection *conn, YwPacket *pkt);
void yw_conn_send_and_free(YwConnection *conn, YwPacket *pkt);

/* packets can be queued and send at once */
void yw_conn_queue(YwConnection *conn, YwPacket *pkt);
void yw_conn_queue_and_free(YwConnection *conn, YwPacket *pkt);
void yw_conn_queue_flush(YwConnection *conn);

/* 127 ASCII characters, and all characters in <yw/unigfx.h> are
 * precached by default. */
void yw_conn_cache_widths(YwConnection *conn, const YwString *);
int yw_conn_char_width(YwConnection *conn, uint32_t ch);
/* count length of *entire* string str, not only the first character */
int yw_conn_string_width(YwConnection *conn, const YwString *str);

/* 127 ASCII characters, and all characters in <yw/unigfx.h>, maybe more */
YwString *yw_get_precache();

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* YW_SOCK_H */
