/* $Id: packet.h,v 1.9 2001/05/21 09:58:54 malekith Exp $ */

#ifndef YW_PACKET_H
#define YW_PACKET_H

#include <yw/word.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* YwPacket type represents one logical call, possibly containing 
 * multiple words */

typedef struct YwPacket_struct YwPacket;
struct YwPacket_struct;

typedef enum {
	yw_call_packet		= 'c',
	yw_void_call_packet	= 'v',
	yw_reply_packet		= 'r',
	yw_taglist_packet	= 't'
} YwPacketType;

/* packet query functions: */
YwPacketType yw_packet_type(YwPacket *pkt);	
void yw_packet_set_type(YwPacket *pkt, YwPacketType t);
int yw_packet_length(YwPacket *pkt);	/* in words */
YwWord *yw_packet_word(YwPacket *pkt, int nth);
					/* returns nth word, next field of
					 * YwWord can also be used */

/* packet construction functions: */
YwPacket *yw_packet_new(YwPacketType type);
YwPacket *yw_packet_copy_of(const YwPacket *src);
void yw_packet_append_keyword(YwPacket *pkt, const char *keyword);
void yw_packet_append_void(YwPacket *pkt);
void yw_packet_append_int(YwPacket *pkt, int32_t i);
void yw_packet_append_ptr(YwPacket *pkt, void *ptr);
void yw_packet_append_string(YwPacket *pkt, const YwString *str);
void yw_packet_append_bindata(YwPacket *pkt, const void *ptr, int len);

void yw_packet_append_word(YwPacket *pkt, const YwWord *w);
void yw_packet_append_word_no_copy(YwPacket *pkt, YwWord *w);

/* copy given words, if len == -1, all available words
 * are copied */
void yw_packet_append_words(YwPacket *pkt, const YwWord *w, int len);

#define YW_END	((char*)0)

YwPacket *yw_packet_make(YwPacketType type, ...);
YwPacket *yw_packet_make_v(YwPacketType type, va_list ap);
 
void yw_packet_free(YwPacket *pkt);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* YW_PACKET_H */
