/* $Id: lock.h,v 1.3 2001/05/04 11:04:32 malekith Exp $ */

#ifndef YW_LOCK_H
#define YW_LOCK_H

#include <yw/types.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifdef YW_HAS_PTHREAD
#include <pthread.h>
#define YW_LOCK_INIT {PTHREAD_MUTEX_INITIALIZER, 0}
#else
#define YW_LOCK_INIT {0,0}
#endif

typedef struct YwLock_struct YwLock;

struct YwLock_struct {
	/* close eyes {{{ */
#ifdef YW_HAS_PTHREAD
	pthread_mutex_t m;
#else
	int m;
#endif
	int rd_cnt;
	/* }}} can open eyes :^) */
};

/* any number of ro locks can be issued, rw is exclusive.
 * lock cannot be at the same time ro and rw locked. */
void yw_lock_ro(YwLock *l);
void yw_unlock_ro(YwLock *l);
void yw_lock_rw(YwLock *l);
void yw_unlock_rw(YwLock *l);

/* aliases for *_rw */
void yw_lock(YwLock *l);
void yw_unlock(YwLock *l);

void yw_lock_init(YwLock *l);
void yw_lock_destroy(YwLock *l);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* YW_LOCK_H */
