/* $Id: keys.h,v 1.1 2001/05/04 11:04:32 malekith Exp $ */

#ifndef YW_KEYS_H
#define YW_KEYS_H

#include <yw/packet.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

enum {
	yw_key_unknown		= 0,
/* don't change { */
	yw_key_up,		/* ^[[A */
	yw_key_down,
	yw_key_right,
	yw_key_left,		/* ^[[D */
	yw_key_home,		/* ^[[1~ */
	yw_key_ins,
	yw_key_del,
	yw_key_end,
	yw_key_pgup,
	yw_key_pgdn,		/* ^[[6~ */
/* } */	
	yw_key_keypad5,		/* ^[[G */
	yw_key_backspace,
	yw_key_f0 		= 0x0100,
	yw_key_flast		= 0x0200,

	yw_key_meta		= 0x1000,
	yw_key_ctrl		= 0x2000
};

#define YW_KEY_F(a) ((a) + yw_key_f0)

#define YW_KEY_IS_F(a) ((a) > yw_key_f0 && (a) <= yw_key_flast)
#define YW_KEY_FVAL(a) (YW_KEY_IS_F(a) ? ((a) - yw_key_f0) : -1)

int yw_key_normal(YwPacket *pkt, YwString **str, int *flags);
int yw_key_special(YwPacket *pkt, int *key, int *flags);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* YW_KEYS_H */
