/* $Id: packet.h,v 1.3 2001/05/04 11:04:33 malekith Exp $ */

#ifndef YW_INT_PACKET_H
#define YW_INT_PACKET_H

#include <yw/packet.h>

struct YwPacket_struct {
	YwPacket *next;
	int type;		/* one of YW_PACKET_* */
	int len;		/* in words */
	YwWord *words;		/* NULL terminated list of (len) words, 
				 * possible types of each word is either 
				 * YW_KEYWORD, YW_STRING or YW_INT
				 * YW_*_LEN is stripped, first word 
				 * is YW_KEYWORD 
				 */
};

struct YwWord_struct {
	YwWord *next;			/* pointer to next word */
	YwWordType type;
	union {
		int32_t i;
		char *ascii;		/* it's nul terminated by library */
		struct {
			uint8_t *data;
			int len;
		} bin;
		YwString string;
		void *ptr;
	} val;
};

#endif /* YW_INT_PACKET_H */
