/* $Id: conn.h,v 1.8 2001/05/04 11:04:33 malekith Exp $ */

#ifndef YW_INT_CONN_H
#define YW_INT_CONN_H

#include <yw/sock.h>

#define YW_NO		0
#define YW_YES		1
#define YW_MAYBE	2

struct YwConnection_struct {
	char *authority_file;
	char *random_file;		/* /dev/urandom */
	char *randseed;			/* ~/.Yrandseed */
	char *display;
	char *home;

	char *err_file;
	int err_line;

	int zlib;
	int crypt;

	void *zlib_state;
	void *crypt_state;

	int sock_fd;
	
	int (*read)(YwConnection *conn, void *buf, int n);
	int (*can_read)(YwConnection *conn, int timeout);
	int (*write)(YwConnection *conn, const void *buf, int n);

	int state;

	int server;

	uint8_t *cookie;
	uint8_t *authority;

	uint8_t *pkt_queue;
	int pkt_queue_size;

	YwPacket *pkt_waiting;

	struct YwRecvState_struct *recv_state;
	struct YwCharWidths_struct *cw;
};

#endif /* YW_INT_CONN_H */
