/* $Id: buffer.h,v 1.3 2001/05/04 11:04:33 malekith Exp $ */

#ifndef YW_INT_BUFFER_H
#define YW_INT_BUFFER_H

#include <yw/buffer.h>

/* this is for char flags */
#define F_BOLD		0x0001
#define F_UNDERLINE 	0x0002
#define F_DRAWABLE	(F_BOLD | F_UNDERLINE)
#define F_CHANGED 	0x0004
#define F_NULL	 	0x0008	/* it's just a filler */

typedef struct Char_struct Char;
typedef struct Line_struct Line;

struct Char_struct {
	uint16_t flags;
	uint8_t fg;		/* we support just 16 colors now... */
	uint8_t bg;
	uint32_t ch;
	Char *addons;
};

struct Line_struct {
	Char *chars;
	/* int changed; */
};

struct YwBuffer_struct {
	Char attr;
	Char nul_attr;
	int w, h;
	Line *lines;
	
	int x, y;
	int last_x, last_y;
	Char *last;
	
	YwBufferCallback *cb;
	void *cb_data;

	YwBuffer *second;
};

#endif /* YW_INT_BUFFER_H */
