/* $Id: hash.h,v 1.3 2001/05/04 11:04:32 malekith Exp $ */

#ifndef YW_HASH_H
#define YW_HASH_H

#include <yw/types.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef struct YwHashEntry_struct YwHashEntry;
typedef struct YwHash_struct YwHash;
struct YwHashEntry_struct;

/* must be derived by hash objects: */
struct YwHashEntry_struct {
	YwHashEntry *next;
	const char *name;
};

typedef void (*YwHashFreeFunc)(YwHashEntry *entry);
typedef void (*YwHashWalkFunc)(void *userdata, YwHashEntry *entry);

YwHash *yw_hash_new();
void yw_hash_free(YwHash *h, YwHashFreeFunc free_item);
void yw_hash_add(YwHash *h, void *ee);
void yw_hash_walk(YwHash *h, YwHashWalkFunc walk, void *userdata);
void *yw_hash_find(YwHash *h, const char *name);
void *yw_hash_unlink(YwHash *h, const char *name);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* YW_HASH_H */
