/* $Id: display.h,v 1.3 2001/05/04 11:04:32 malekith Exp $ */

#ifndef YW_DISPLAY_H
#define YW_DISPLAY_H

#include <yw/sock.h>
#include <yw/buffer.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define YW_DISPLAY_CAP_COLOR		0x0001
#define YW_DISPLAY_CAP_BOLDFACE		0x0002
#define YW_DISPLAY_CAP_UNDERLINE	0x0004
#define YW_DISPLAY_CAP_HIGH_BG		0x0008
#define YW_DISPLAY_CAP_MOUSE		0x0010


typedef struct YwDisplayCallbacks_struct YwDisplayCallbacks;

struct YwDisplayCallbacks_struct {
	void *userdata;
	
	int caps;
	int width;
	int height;
	
	YwConnection *conn;
	
	void (*do_goto)(YwDisplayCallbacks *self, int x, int y);
	void (*do_print)(YwDisplayCallbacks *self, const YwString *str);
	void (*do_attr)(YwDisplayCallbacks *self, YwBufAttr attr, int val);
	void (*do_flush)(YwDisplayCallbacks *self);
	int (*char_width)(YwDisplayCallbacks *self, uint32_t ch);
	void (*do_quit)(YwDisplayCallbacks *self);
};


void yw_display_send_caps(YwDisplayCallbacks *cb);
char *yw_display_dispatch_packet(YwDisplayCallbacks *cb, YwPacket *pkt);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* YW_DISPLAY_H */
