/* $Id: buffer.h,v 1.5 2001/05/21 09:58:54 malekith Exp $ */

#ifndef YW_BUFFER_H
#define YW_BUFFER_H

#include <yw/string.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef struct YwBuffer_struct YwBuffer;
struct YwBuffer_struct;

typedef struct YwBufferCallback_struct YwBufferCallback;
struct YwBufferCallback_struct;

YwBuffer *yw_buffer_new(YwBufferCallback *callback, void *userdata,
			int w, int h, int syncable);
void yw_buffer_free(YwBuffer *buf);

void yw_buffer_sync(YwBuffer *buf);
int yw_buffer_strlen(YwBuffer *buf, const YwString *str);

/*** 
 *** drawing primitives 
 ***/
void yw_buffer_goto(YwBuffer *buf, int x, int y);
void yw_buffer_putchar(YwBuffer *buf, uint32_t unicode_character);
void yw_buffer_puts(YwBuffer *buf, const YwString *str);
void yw_buffer_putbuffer(YwBuffer *dst, int dst_x, int dst_y, 
					int dst_w, int dst_h,
		   const YwBuffer *src, int src_x, int src_y); 
int yw_buffer_get_x(YwBuffer *buf);
int yw_buffer_get_y(YwBuffer *buf);

/* VT helpers: */
void yw_buffer_delline(YwBuffer *buf);
void yw_buffer_insline(YwBuffer *buf);
void yw_buffer_delchar(YwBuffer *buf);
void yw_buffer_inschar(YwBuffer *buf);

/* these are general ANSI terminal attributes,
 * thinking about RGB color. */
#define YW_COLOR_ANSI_BLACK		0x01000000
#define YW_COLOR_ANSI_RED		0x01000001
#define YW_COLOR_ANSI_GREEN		0x01000002
#define YW_COLOR_ANSI_BROWN		0x01000003
#define YW_COLOR_ANSI_BLUE		0x01000004
#define YW_COLOR_ANSI_MAGENTA		0x01000005
#define YW_COLOR_ANSI_CYAN		0x01000006
#define YW_COLOR_ANSI_LIGHTGRAY		0x01000007
#define YW_COLOR_ANSI_GRAY		0x01000008
#define YW_COLOR_ANSI_LIGHTRED		0x01000009
#define YW_COLOR_ANSI_LIGHTGREEN	0x0100000a
#define YW_COLOR_ANSI_YELLOW		0x0100000b
#define YW_COLOR_ANSI_LIGHTBLUE		0x0100000c
#define YW_COLOR_ANSI_LIGHTMAGENTA	0x0100000d
#define YW_COLOR_ANSI_LIGHTCYAN		0x0100000e
#define YW_COLOR_ANSI_WHITE		0x0100000f

void yw_buffer_set_fg(YwBuffer *buf, int color);
void yw_buffer_set_bg(YwBuffer *buf, int color);

/* regular console terminals display doesn't claim that they support
 * underline nor bold. It's reserver for REAL bold/underline,
 * like in xterm */
void yw_buffer_set_bold(YwBuffer *buf, int on_off);
void yw_buffer_set_underline(YwBuffer *buf, int on_off);

void yw_buffer_reset_attr(YwBuffer *buf);
void yw_buffer_clr(YwBuffer *buf);

/*** 
 *** callback 
 ***/

typedef enum {
	yw_bufattr_bad,
	yw_bufattr_fg,
	yw_bufattr_bg,
	yw_bufattr_underline,		/* 0|1 */
	yw_bufattr_bold,		/* 0|1 */
	yw_bufattr_reset
} YwBufAttr;

const char *yw_bufattr_name(YwBufAttr attr);
YwBufAttr yw_bufattr_from_keyword(const char *name);
void yw_buffer_set_attr(YwBuffer *buf, YwBufAttr attr, int val);

struct YwBufferCallback_struct {
	/* results aren't cached. it's up to you to make it efficient */
	int (*char_width)(void *userdata, uint32_t ch);
	void (*cache_widths)(void *userdata, const YwString *s); /* optional */
	
	void (*remote_goto)(void *userdata, int x, int y);
	void (*remote_puts)(void *userdata, const YwString *str);
	void (*remote_attr)(void *userdata, YwBufAttr bufattr, int val);
	void (*remote_flush)(void *userdata);	/* optional */
};

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* YW_BUFFER_H */
