/* $Id: util.h,v 1.4 2001/06/02 11:18:30 malekith Exp $ */

#ifndef YTK_UTIL_H
#define YTK_UTIL_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* general utilites */
void ytk_fatal(const char *fmt, ...);
void ytk_fatal_v(const char *fmt, va_list ap);

void ytk_draw(YtkObject *);

/* resp should return 0 if event was handled, -1 otherwise */
typedef int (*YtkResponder)(void *userdata, 
			    const char *event_name,
			    YwWord *arg);
			    
YtkObject *ytk_responder(void *data, YtkResponder resp_fnc); 

YwWord *ytk_get_op(YtkObject *o, const char *name);
int ytk_set_op(YtkObject *o, const char *name, const YwWord *val);

/* Target is first yw_string_free()ed|yw_free()ed, and then assigned
 * value of given op. 0 if successful, -1 otherwise. */
int ytk_get_string_op(YtkObject *o, const char *name, YwString *target);
int ytk_get_keyword_op(YtkObject *o, const char *name, char **target);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* YTK_UTIL_H */
