/* $Id: object.h,v 1.4 2001/05/24 14:53:59 malekith Exp $ */

#ifndef YTK_OBJECT_H
#define YTK_OBJECT_H

#include <yw/window.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Abstract type of ytk objects. */
typedef struct YtkObject_struct YtkObject;

/* Add or remove a reference. The reference counter starts at 1.
 * If it drops to 0, the object gets finalized. */
void ytk_inc_ref(YtkObject *obj);
void ytk_dec_ref(YtkObject *obj);

/* class registration framework */
typedef YtkObject *(*YtkCreator)(void *data, YwPacket *tags);
typedef YwPacket *(*YtkCallback)(void *data, YwPacket *msg);
    /* NULL return is equivalent to an empty packet. */
typedef void (*YtkFree)(void *data);

void ytk_register_class(const char *name, 
			YtkCreator creator, void *creator_data);
void ytk_unregister_class(const char *name);
YtkObject *ytk_new_object(const char *class_name, 
			  YtkCallback callback, 
			  YtkFree finalizer,
			  void *data);

YtkObject *ytk_new(const char *name, YwPacket *tags);
YtkObject *ytk_new_va(const char *name, ...);
YtkObject *ytk_new_ap(const char *name, va_list ap);

/* Send it a message (and receive an answer). */
YwPacket *ytk_send_msg(YtkObject *obj, YwPacket *msg);
YwPacket *ytk_send_msg_va(YtkObject *obj, ...);
YwPacket *ytk_send_msg_ap(YtkObject *obj, va_list ap);
void ytk_send_void_msg_va(YtkObject *obj, ...);
void ytk_send_void_msg_ap(YtkObject *obj, va_list ap);

const char *ytk_class_of(YtkObject *);

/* Next/prev/active stuff */
YtkObject *ytk_object_next(YtkObject *);
YtkObject *ytk_object_children(YtkObject *);
YtkObject *ytk_object_focused(YtkObject *);
int ytk_object_focusable(YtkObject *o);
int ytk_object_focus(YtkObject *o, YtkObject *f);
int ytk_object_focus_next(YtkObject *o);
int ytk_object_focus_prev(YtkObject *o);
int ytk_object_has_focus(YtkObject *o);

/* inc ref of child */
void ytk_object_link_child(YtkObject *o, YtkObject *child);

/* In order to link child to new object, you first need to destroy
 * parent it used to have. (as there is no unlink call) */

/* when this changes (link happens) 
 * new_parent event is sent, which. has one argument, ptr to parent. */
YtkObject *ytk_object_parent(YtkObject *);

/* backend-window */
/* this walks through parents, until it finds one bound
 * to window. */
YwWindow *ytk_object_window(YtkObject *);
void ytk_bind_object_to_window(YtkObject *, YwWindow *);

/* events stuff */

/* inc ref of resp */
void ytk_object_set_responder(YtkObject *o, YtkObject *resp);
void ytk_object_send_event_up(YtkObject *self, YwPacket *pkt);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* YTK_OBJECT_H */
