/* $Id: context.h,v 1.1 2001/05/21 09:58:53 malekith Exp $ */

#ifndef YTK_CONTEXT_H
#define YTK_CONTEXT_H

#include <ytk/object.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef struct YtkContext_struct YtkContext;
struct YtkContext_struct;

/*
 * All objects are implicitly bound to ytk_default_context().
 * Binding only makes sense for highest level objects, i.e. windows.
 */
void ytk_bind_to_context(YtkContext *ctx, YtkObject *o);
YtkContext *ytk_new_context();
YtkContext *ytk_default_context();

void ytk_bind_connection_to_context(YtkContext *ctx, YwConnection *conn);

/* if ctx == NULL default context is used */
YwPacket *ytk_process_events(YtkContext *ctx, int timeout);

YwConnection *ytk_init();
void ytk_check_state(YtkContext *ctx);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* YTK_CONTEXT_H */
