/* $Id: exceptions.h,v 1.3 2001/05/21 09:58:53 malekith Exp $ */

// Included by String.h.

#ifndef YPP_EXCEPTIONS_H
#define YPP_EXCEPTIONS_H

namespace Ypp {

class Packet;

class Exception {
public:
	String msg;

	void print();
	Packet get_packet();
	Exception(const String &m = "") : msg(m) {}
	
	static void throw_packet(const Packet &pkt);
};


class ConversionException : public Exception {
public:
	ConversionException(const String &m = "") : Exception(m) {}
};

class StringIdxException : public Exception {
public:
	StringIdxException(const String &m = "") : Exception(m) {}
};

class WordTypeException : public Exception {
public:
	WordTypeException(const String &m = "") : Exception(m) {}
};

class LogicException : public Exception {
public:
	LogicException(const String &m = "") : Exception(m) {}
};

class MsgNotUnderstoodException : public Exception {
public:
	MsgNotUnderstoodException(const String &m = "") : Exception(m) {}
};

class BadMsgArgsException : public Exception {
public:
	BadMsgArgsException(const String &m = "") : Exception(m) {}
};

class InvalidTagException : public Exception {
public:
	InvalidTagException(const String &m = "") : Exception(m) {}
};

class TagNotFoundException : public Exception {
public:
	TagNotFoundException(const String &m = "") : Exception(m) {}
};

class OpException : public Exception {
public:
	OpException(const String &m = "") : Exception(m) {}
};


// -- these donate logic error in code
class WordNotFoundException : public LogicException {
public:
	WordNotFoundException(const String &m = "") : LogicException(m) {}
};

class NoNextTagException : public LogicException {
public:
	NoNextTagException(const String &m = "") : LogicException(m) {}
};

class ObjectException : public LogicException {
public:
	ObjectException(const String &m = "") : LogicException(m) {}
};


/*
class Exception : public Exception {
public:
	Exception(const String &m = "") : Exception(m) {}
};
*/

}


#endif /* YPP_EXCEPTIONS_H */
