/* $Id: Word.h,v 1.3 2001/05/21 09:58:53 malekith Exp $ */

#ifndef YPP_WORD_H
#define YPP_WORD_H

#include <ypp/String.h>
#include <ypp/BinData.h>

#include <yw/packet.h>
#include <yw/map.h>

namespace Ypp {

class Word {
public:
	// throw WordTypeException
	int32_t integer() const;
	AsciiString keyword() const;
	String string() const;
	void *ptr() const;
	BinData bindata() const;
	int mapped_keyword(const YwMapEntry e[], YwMapCache ** = NULL) const;

	Word(int32_t);
	Word(const char *);
	Word(const AsciiString &);
	Word(const String &);
	Word(void *);
	Word(const BinData &);
	Word();		// void
	Word(const YwWord *);
	static Word bad();
	static Word no_copy(YwWord *);
	Word(const Word &);
	
	const Word &operator = (const Word &);
	const YwWord *ref() const;
	~Word();
	
	YwWordType type() const;
	
private:
	YwWord *data;
	Word(int, YwWord *);
};


//
// Stop reading here... inline stuff starts...
//

inline const YwWord *Word::ref() const
{
	return data;
}

inline Word::~Word()
{
	yw_word_free(data);
}

inline YwWordType Word::type() const
{
	return yw_word_type(data);
}

inline Word::Word(const YwWord *p)
	: data(yw_word_copy_of(p))
{
}

inline Word::Word(int, YwWord *p) 
	: data(p)
{
}

inline Word::Word(int32_t i) 
	: data(yw_word_new_int(i))
{
}

inline Word::Word(const char *s)
	: data(yw_word_new_keyword(s))
{
}

inline Word::Word(const AsciiString &s)
	: data(yw_word_new_keyword(s.ref()))
{
}

inline Word::Word(const String &s)
	: data(yw_word_new_string(s.ref()))
{
}

inline Word::Word(void *ptr)
	: data(yw_word_new_ptr(ptr))
{
}

inline Word::Word(const BinData &b)
	: data(yw_word_new_bindata(b.ref_ptr(), b.ref_len()))
{
}

inline Word::Word()
	: data(yw_word_new_void())
{
}

inline Word::Word(const Word &s)
	: data(yw_word_copy_of(s.ref()))
{
}

inline Word Word::no_copy(YwWord *p)
{
	return Word(0, p);
}

inline Word Word::bad()
{
	return no_copy(yw_word_new_bad());
}

}

#endif /* YPP_WORD_H */
