/* $Id: Widget.h,v 1.3 2001/05/24 14:53:59 malekith Exp $ */

#ifndef YPP_WIDGET_H
#define YPP_WIDGET_H

#include <ypp/Class.h>
#include <ypp/Buffer.h>
#include <ypp/TagList.h>

#include <yw/keys.h>

struct Size {
	static const int infinity;
	
	int w, h;
	
	Size(int ww, int hh) : w(ww), h(hh) {}
	Size() : w(0), h(0) {}
};

struct VarSize {
	Size min;
	Size mid;
	Size max;

	VarSize() {}
	VarSize(Size m) : min(m), mid(m), max(m) {}
	VarSize(Size mmin, Size mmid, Size mmax) : 
		min(mmin), mid(mmid), max(mmax) {}
};

namespace Ypp {

class Widget : public Class {
public:
	Widget();
	virtual Packet dispatch(const Packet &);
	virtual void init(const TagList &pkt);

protected:
	Buffer buf;

	VarSize preset;

	int width, height;	// current
	int pos_x, pos_y;	// inside buf.

	virtual Word get_op(const AsciiString &name);
	virtual void set_op(const AsciiString &name, const Word &w);
	virtual void draw();		// does nothing
	virtual void lost_parent();	// invalidates buf
	virtual void new_parent();	// does nothing
	virtual VarSize get_sizes();	// `preset' by default
	virtual void set_position(const TagList &);	// sets x,y,w,h
	virtual bool can_get_focus();	// always false by default

	// default action is to send it up
	virtual void handle_event(const AsciiString &name, const Word &name);

	// handle_key() by default calls handle_{norm,spec}_key
	// as needed.
	// all handle_* functions should return true when 
	// event is handled.
	virtual bool handle_key(const Packet &pkt);
	virtual bool handle_norm_key(const String &str, int flags);
	virtual bool handle_spec_key(int key, int flags);

	// to be called from methods
	virtual void redraw();

	void set_named_ops(const char **, const TagList &);
	bool no_buf();
};

}

#endif /* YPP_WIDGET_H */
