/* $Id: TagList.h,v 1.3 2001/05/21 09:58:53 malekith Exp $ */

#ifndef YPP_TAGLIST_H
#define YPP_TAGLIST_H

#include <ypp/Packet.h>

namespace Ypp {

class TagList {
public:
	AsciiString name();
	Word value();

	// stateful
	// throw NoNextTagException
	void next();
	bool eot();
	void reset();
	
	// throw TagNotFoundException
	Word find(const AsciiString &) const;
	bool present(const AsciiString &) const;

	Word find(const AsciiString &, const Word &def) const;
	
	// throw InvalidTagListException
	TagList(const Packet &pkt, int skip = 0);
	
private:
	Packet copy;
	const YwWord *head;
	const YwWord *cur;
};

}

#endif /* YPP_TAGLIST_H */
