/* $Id: String_inlines.h,v 1.2 2001/05/21 09:58:53 malekith Exp $ */

// This file is not intended to be used directly, nor read.

namespace Ypp {

inline bool operator == (const String &s1, const String &s2)
{
	return yw_string_cmp(s1.ref(), s2.ref()) == 0;
}

inline bool operator != (const String &s1, const String &s2)
{
	return yw_string_cmp(s1.ref(), s2.ref()) != 0;
}

inline const String & String::operator += (const String &s)
{
	yw_string_concat(&data, s.ref());
	
	return *this;
}

inline String::String()
{
	yw_string_assign_empty(&data);
}

inline String::String(int ch)
{
	yw_string_assign_one_char(&data, ch);
}

inline String::String(const char *str)
{
	if (yw_string_assign_cstring(&data, NULL, str, -1))
		throw ConversionException();
}

inline String::String(const char *enc, const char *chars, int len)
{
	if (yw_string_assign_cstring(&data, enc, chars, len))
		throw ConversionException();
}

inline String::String(const String &r)
{
	yw_string_assign_string(&data, r.ref());
}

inline String::String(const YwString *str)
{
	yw_string_assign_string(&data, str);
}

inline String::String(const uint32_t *chars, int len)
{
	yw_string_assign_utf32(&data, chars, len);
}

inline String::String(const uint16_t *chars, int len)
{
	if (yw_string_assign_utf16(&data, chars, len))
		throw ConversionException();
}

inline String::String(const uint8_t *chars, int len)
{
	if (yw_string_assign_utf8(&data, chars, len))
		throw ConversionException();
}

inline const YwString *String::ref() const
{
	return &data;
}

inline void String::get_utf32(uint32_t **chars, int *len)
{
	yw_string_get_utf32(&data, chars, len);
}

inline void String::get_utf16(uint16_t **chars, int *len)
{
	yw_string_get_utf16(&data, chars, len);
}

inline void String::get_utf8(uint8_t **chars, int *len)
{
	yw_string_get_utf8(&data, chars, len);
}

inline String::~String()
{
	yw_string_free(&data);
}

inline int String::length() const
{
	return ref()->len;
}

}
