/* $Id: String.h,v 1.3 2001/05/21 09:58:53 malekith Exp $ */

#ifndef YPP_STRING_H
#define YPP_STRING_H

#include <stdio.h>

#include <ypp/AsciiString.h>
#include <yw/string.h>

namespace Ypp {

// full featured UNICODE string

class String {
	YwString data;
public:
	String();
	String(int ch);
	String(const char *str);
	String(const char *enc, const char *chars, int len = -1);
	String(const YwString *str);
	String(const String &r);
	String(const uint32_t *chars, int len);
	String(const uint16_t *chars, int len);
	String(const uint8_t *chars, int len);
	const String & operator = (const String &);

	void get_utf32(uint32_t **chars, int *len);
	void get_utf16(uint16_t **chars, int *len);
	void get_utf8(uint8_t **chars, int *len);
	
	AsciiString get_cstring(const char *enc = NULL, int *len = NULL);
	
	const YwString *ref() const;

	int idx(uint32_t ch);
	const String & operator += (const String &);

	~String();

	uint32_t operator[] (int) const;
	uint32_t &operator[] (int);
	int length() const;
};


inline bool operator == (const String &s1, const String &s2);
inline bool operator != (const String &s1, const String &s2);

}

#include <ypp/exceptions.h>
#include <ypp/String_inlines.h>

#endif /* YPP_STRING_H */
