/* $Id: Packet.h,v 1.3 2001/05/21 09:58:53 malekith Exp $ */

#ifndef YPP_PACKET_H
#define YPP_PACKET_H

#include <ypp/Word.h>

namespace Ypp {

class Packet {
public:
	const YwWord *bare_word(int n) const;
	
	const YwPacket *ref() const { return data; } 
	Packet(const YwPacket *pkt);
	Packet(const YwWord *w, int len = -1, 
	       YwPacketType type = yw_taglist_packet);
	Packet(YwPacketType t, ...);
	Packet();

	Packet(const Packet &);
	const Packet &operator =(const Packet &);
	~Packet();

	YwPacketType type() const;

	int length() const;
	// throw WordNotFoundException
	Word word(int) const;
	
	void append(const Word &w);

	// hm...
	void append_keyword(const char *s)	{ append(Word(s)); }
	void append_string(const String &s)	{ append(Word(s)); }
	void append_void()			{ append(Word()); }
	void append_int(int32_t i)		{ append(Word(i)); }
	void append_ptr(void *ptr)		{ append(Word(ptr)); }
	void append_bindata(const BinData &b)	{ append(Word(b)); }
private:
	YwPacket *data;
};

inline const YwWord *Packet::bare_word(int n) const
{
	return (const YwWord*)yw_packet_word((YwPacket*)data, n);
}

inline YwPacketType Packet::type() const
{
	return yw_packet_type(data);
}

inline Packet::~Packet()
{
	yw_packet_free(data);
}

inline int Packet::length() const
{
	return yw_packet_length(data);
}

}

#endif /* YPP_PACKET_H */

