/* $Id: Object.h,v 1.4 2001/05/24 14:53:59 malekith Exp $ */

#ifndef YPP_OBJECT_H
#define YPP_OBJECT_H

#include <ytk/ytk.h>
#include <ypp/Packet.h>

namespace Ypp {

class Object {
public:
	const YtkObject *ref() const { return obj; }

	// calls ytk_inc_ref() on obj and returns it.
	YtkObject *steal_ref();

	Packet send_msg(const Packet &msg);
	Word op(const AsciiString &name);
	void set_op(const AsciiString &name, const Word &val);
	void set_op(const Packet &tags);

	Object(const char *name, const Packet &tags);
	Object(const Object &r);
	// can throw ObjectException("NULL object")
	Object(const YtkObject *);
	~Object();
	const Object &operator =(const Object &r);

	bool focusable() { return ytk_object_focusable(obj); }
	bool has_next() { return ytk_object_next(obj) != NULL; }
	bool has_children() { return ytk_object_children(obj) != NULL; }
	bool has_focused() { return ytk_object_focused(obj) != NULL; }
	bool has_parent() { return ytk_object_parent(obj) != NULL; }
	bool has_focus() { return ytk_object_has_focus(obj); }

	// all can throw ObjectException
	Object next() { return ytk_object_next(obj); }
	Object children() { return ytk_object_children(obj); }
	Object focused() { return ytk_object_focused(obj); }
	Object parent() { return ytk_object_parent(obj); }
	void link_child(Object o)
		// ytk_object_link() does reference inc for us.
		{ ytk_object_link_child(obj, o.obj); }
	void bind_to_window(YwWindow *w)
		{ ytk_bind_object_to_window(obj, w); }
	YwWindow *window()
		{ return ytk_object_window(obj); }

	void focus_next() { ytk_object_focus_next(obj); }
	void focus_prev() { ytk_object_focus_prev(obj); }

	void focus(Object o)
		{ if (ytk_object_focus(obj, o.obj))
			throw ObjectException("not focusable"); }
	
	void set_responder(Object o)
		{ ytk_object_set_responder(obj, o.obj); }
	void send_event_up(const AsciiString &name, const Word &val);
	
private:
	YtkObject *obj;
};

}

#endif /* YPP_OBJECT_H */
