/* $Id: Input.h,v 1.1 2001/05/21 09:58:53 malekith Exp $ */

#ifndef YPP_INPUT_H
#define YPP_INPUT_H

#include <ypp/Widget.h>

namespace Ypp {

class Input : public Widget {
public:
	Input();
	virtual void init(const TagList&);

protected:
	virtual Word get_op(const AsciiString &name);
	virtual void set_op(const AsciiString &name, const Word &w);
	virtual void draw();
	virtual bool handle_norm_key(const String &str, int flags);
	virtual bool handle_spec_key(int key, int flags);
	virtual bool can_get_focus();

	String text;
	int fg_color, bg_color;
	int focused_fg_color, focused_bg_color;

	void fix_offset();
	int pos;	// of cursor
	int off;
};

}

#endif /* YPP_INPUT_H */
