/* $Id: Group.h,v 1.2 2001/05/21 09:58:53 malekith Exp $ */

#ifndef YPP_GROUP_H
#define YPP_GROUP_H

#include <ypp/Widget.h>

namespace Ypp {

class Group : public Widget {
public:
	Group();
	void init(const TagList &t);
	virtual ~Group();

protected:
	enum Layout {
		horizontal,
		vertical
	};

	Layout layout;
	int spacing;
	
	virtual Word get_op(const AsciiString &name);
	virtual void set_op(const AsciiString &name, const Word &w);
	virtual void draw();
	virtual void new_parent();
	virtual void lost_parent();
	virtual VarSize get_sizes();
	virtual void set_position(const TagList &);
	virtual bool handle_norm_key(const String &str, int flags);
	virtual bool handle_spec_key(int key, int flags);
	virtual bool can_get_focus();

private:
	class CacheEntry {
	public:
		VarSize size;
		CacheEntry *next;

		CacheEntry(VarSize s, CacheEntry *n) : size(s), next(n) {}
	};
	CacheEntry *cache;
	void clear_cache();
	
	VarSize process_sizes(VarSize &vs, const TagList &t, int);
	void broadcast(const Packet &pkt);
	void adjust_positions(int sum);
};

}

#endif /* YPP_GROUP_H */
