/* $Id: Class.h,v 1.3 2001/05/21 09:58:53 malekith Exp $ */

#ifndef YPP_CLASS_H
#define YPP_CLASS_H

#include <ypp/Packet.h>
#include <ypp/Object.h>
#include <ypp/TagList.h>

#include <cstring>

namespace Ypp {

class Class {
private:
	YtkObject *self;

public:
	virtual ~Class();
	virtual Packet dispatch(const Packet &msg);
	virtual void init(const TagList &) = 0;
	
	// this functions can be used just once,
	// uppon initialization. It's usually called
	// only by RegisterClass::create(), don't attempt
	// to call it directly, unless you know what you're
	// doing.
	void set_self(YtkObject *s);

	static void global_finalizer(void *data);
	static YwPacket *global_callback(void *data, YwPacket *msg);
protected:
	Object get_self() { return self; }
	
	Class() : self(NULL) {}
};

template <class T>
class RegisterClass {
public:
	static YtkObject *create(void *, YwPacket *msg);
	void init(const char *name);
};

template <class T>
YtkObject *RegisterClass<T>::create(void *name, YwPacket *msg)
{
	Class *c;
	YtkObject *o;
	
	c = new T;
	o = ytk_new_object((const char*)name, 
			   Class::global_callback,
			   Class::global_finalizer,
			   (void*)(c));
	c->set_self(o);
	c->init(Packet(msg));
	
	return o;
}

template <class T>
void RegisterClass<T>::init(const char *name)
{
	ytk_register_class(name, &create, (void*)name);
}

}

/*
// An Idea
class OneShot : public Class {
public:
	virtual void init(const TagList &){}
	OneShot() {}
};

template <class T>
class OneShotCreator {
public:
	YtkObject *create();
};

OneShotCreator<MyClass>().create()
*/

#endif /* YPP_CLASS_H */
