/* $Id: Buffer.h,v 1.2 2001/05/21 09:58:53 malekith Exp $ */

#ifndef YPP_BUFFER_H
#define YPP_BUFFER_H

namespace Ypp {

//
// This class doesn't do any buffer deallocation.
//

class Buffer {
public:
	YwBuffer *buf;

	Buffer(YwBuffer *b = NULL) : buf(b) {}

	void sync() { yw_buffer_sync(buf); }
	int strlen(const String &s)
		{ return yw_buffer_strlen(buf, s.ref()); }
	void bgoto(int x, int y)
		{ yw_buffer_goto(buf, x, y); }
	void bputchar(uint32_t ch)
		{ yw_buffer_putchar(buf, ch); }
	void bputs(const String &s)
		{ yw_buffer_puts(buf, s.ref()); }
	void fg(int c)
		{ yw_buffer_set_fg(buf, c); }
	void bg(int c)
		{ yw_buffer_set_bg(buf, c); }
	void bold(bool x)
		{ yw_buffer_set_bold(buf, x); }
	void underline(bool x)
		{ yw_buffer_set_bold(buf, x); }
	void reset()
		{ yw_buffer_reset_attr(buf); }
	void clr()
		{ yw_buffer_clr(buf); }
	int get_x()
		{ return yw_buffer_get_x(buf); }
	int get_y()
		{ return yw_buffer_get_y(buf); }
};

}

#endif /* YPP_BUFFER_H */
