/* $Id: AsciiString.h,v 1.3 2001/05/21 09:58:52 malekith Exp $ */

#ifndef YPP_ASCIISTRING_H
#define YPP_ASCIISTRING_H

#include <yw/map.h>
#include <yw/util.h>
#include <string.h>

namespace Ypp {

class AsciiString {
public:
	char *data;
	
	~AsciiString() { yw_free(data); }
	AsciiString(const char *s = "") : data(yw_strdup(s)) {}
	AsciiString(int, char *s) : data(s) {}
	const AsciiString &operator =(const AsciiString &r)
	{
		if (&r != this)
			yw_setstr(&data, r.data);
			
		return *this;
	}
	AsciiString(const AsciiString &r) : data(yw_strdup(r.data)) {}
	
	const char *ref() const { return data; }

	int map(const YwMapEntry e[], YwMapCache **c = NULL) const
		{ return yw_map(data, e, c); }
};


inline bool operator ==(const AsciiString &a1, const AsciiString &a2)
{
	return strcmp(a1.ref(), a2.ref()) == 0;
}

inline bool operator !=(const AsciiString &a1, const AsciiString &a2)
{
	return !(a1 == a2);
}

}

#endif /* YPP_ASCIISTRING_H */
