/* $Id: wm.c,v 1.1 2001/05/23 08:46:01 malekith Exp $ */

#include "serv.h"
#include "win.h"

struct WM_struct {
	int nothing_needed_yet;		/* :^) */
};

void free_wm(Conn *c)
{
	yw_free(c->wm);
	if (c == conn_wm)
		conn_wm = NULL;
}

void init_wm(Conn *c)
{
	if (c->wm)
		return;		/* already done */
		
	lock();
	/* first kill the other wm */
	yw_assert(conn_wm != c);
	if (conn_wm) {
		kill_connection(conn_wm);
	}
	
	conn_wm = c;

	c->wm = YW_NEW_0(WM);
	
	c->type = window_manager;

	unlock();
}

void approx(YwString *str);

static void wm_flush(CallbackData *cd)
{
	Window *w;
	int id;

	id = cd->conn->wm_goto_id;

	printk(YL_DEBUG1 "wm_flush: wm_wm_goto_id=%d", id);
	
	for (w = wm_wins; w; w = w->next_global)
		if (w->wm_win_id == id)
			break;
			
	/* hm.. in fact we don't need window here, but maybe
	 * someday we will, so require it to be set properly... */
	if (w == NULL) {
		cd->err = "wm_flush: window not found";
		return;
	}

	refresh_display();
}

static void wm_print(CallbackData *cd)
{
	Window *w;
	int id;
	YwString *str;
	char *local = NULL;

	yw_word_fetch_string(yw_packet_word(cd->pkt, 1), &str);
	
	id = cd->conn->wm_goto_id;

	yw_string_get_cstring(str, NULL, &local, NULL);
	printk(YL_DEBUG1 "print: '%s' wm_goto_id=%d", local, id);
	yw_free(local);
	
	for (w = wm_wins; w; w = w->next_global)
		if (w->wm_win_id == id)
			break;
			
	if (w == NULL) {
		cd->err = "print: window not found";
		return;
	}

	/* 
	 * this will precache characters widths and replace 
	 * inaccessible characteres by Qrczak's approximations.
	 */
	approx(str);

	yw_buffer_puts(w->wm_buffer, str);
}

static void wm_goto(CallbackData *cd)
{
	Window *win;
	int wm_win_id, x, y;
	
	if (yw_word_fetch_int(yw_packet_word(cd->pkt, 1), &wm_win_id) ||
  	    yw_word_fetch_int(yw_packet_word(cd->pkt, 2), &x) ||
	    yw_word_fetch_int(yw_packet_word(cd->pkt, 3), &y)) {
		cd->err = "wm_goto: bad args";
		return;
	}
		
	printk(YL_DEBUG1 "wm_goto: win=%d to (%d, %d)",
			wm_win_id, x, y);
	for (win = wm_wins; win; win = win->next_global)
		if (win->wm_win_id == wm_win_id)
			break;
	if (win == NULL)
		cd->err = "wm_goto: window not found";
	else {
		cd->conn->wm_goto_id = wm_win_id;
		yw_buffer_goto(win->wm_buffer, x, y);
	}
}

static void wm_move(CallbackData *cd)
{
	Window *win;
	int wm_win_id, x, y;
	
	if (yw_word_fetch_int(yw_packet_word(cd->pkt, 1), &wm_win_id) ||
  	    yw_word_fetch_int(yw_packet_word(cd->pkt, 2), &x) ||
	    yw_word_fetch_int(yw_packet_word(cd->pkt, 3), &y)) {
		cd->err = "wm_move: bad args";
		return;
	}
		
	printk(YL_DEBUG1 "wm_move: win=%d to (%d, %d)",
			wm_win_id, x, y);
	for (win = wm_wins; win; win = win->next_global)
		if (win->wm_win_id == wm_win_id)
			break;
	if (win == NULL)
		cd->err = "wm_move: window not found";
	else {
		win->x = x;
		win->y = y;
		refresh_display();
	}
}

static void wm_kill(CallbackData *cd)
{
	Window *win;
	int wm_win_id;
	
	if (yw_word_fetch_int(yw_packet_word(cd->pkt, 1), &wm_win_id)) {
		cd->err = "wm_kill: bad args";
		return;
	}
		
	printk(YL_DEBUG1 "wm_kill: win=%d", wm_win_id);
	for (win = wm_wins; win; win = win->next_global)
		if (win->wm_win_id == wm_win_id)
			break;
			
	if (win == NULL)
		cd->err = "wm_kill: window not found";
	else {
		kill_connection(win->parent);
	}
}

static void wm_focus(CallbackData *cd)
{
	Window *win;
	int wm_win_id;
	
	if (yw_word_fetch_int(yw_packet_word(cd->pkt, 1), &wm_win_id)) {
		cd->err = "wm_focus: bad args";
		return;
	}
		
	printk(YL_DEBUG1 "wm_focus: win=%d", wm_win_id);
	
	for (win = wm_wins; win; win = win->next_global)
		if (win->wm_win_id == wm_win_id)
			break;
			
	if (win == NULL)
		cd->err = "wm_focus: window not found";
	else
		focus_window(win);
	refresh_display();
}

static void wm_attr(CallbackData *cd)
{
	const char *name;
	int val;
	YwBufAttr a;
	Window *win;

	if (yw_word_fetch_keyword(yw_packet_word(cd->pkt, 1), &name) ||
	    yw_word_fetch_int(yw_packet_word(cd->pkt, 2), &val)) {
	    	cd->err = "wm_attr: bad args";
		return;
	}
	
	a = yw_bufattr_from_keyword(name);
	if (a == yw_bufattr_bad)
		cd->err = "wm_attr: bad attribute";
	else {
		printk(YL_DEBUG1 "wm_attr: (%s -> %d -> %s) <- %d",
				name, (int)a,
				yw_bufattr_name(a),
				val);
		for (win = wm_wins; win; win = win->next_global)
			if (win->wm_win_id == cd->conn->wm_goto_id)
				break;
		if (win == NULL)
			cd->err = "wm_attr: window not found";
		else
			yw_buffer_set_attr(win->wm_buffer, a, val);
	}
}

void install_wm_callbacks()
{
	install_callback("wm_move", 0, wm_move, NULL);
	install_callback("wm_goto", 0, wm_goto, NULL);
	install_callback("wm_flush", yw_void_word, wm_flush, NULL);
	install_callback("wm_print", yw_string_word, wm_print, NULL);
	install_callback("wm_attr", ARG_TAGS, wm_attr, NULL);
	install_callback("wm_focus", yw_int_word, wm_focus, NULL);
	install_callback("wm_kill", yw_int_word, wm_kill, NULL);
}
