#include "serv.h"
#include "win.h"

/* global {{{ */
Window *wm_wins;
int focus_layer = 0;
int wm_current_win_id = 1;
/* }}} */

int int_tag(CallbackData *cd, const char *name, int def)
{
	YwWord *w;

	w = yw_tag_find(yw_packet_word(cd->pkt, 1), name);
	if (w == NULL)
		return def;

	if (yw_word_fetch_int(w, &def))
		cd->err = "exepected int as tag argument";

	return def;
}

static YwBufferCallback bufcb;

static void place_window(Window *w, int focus)
{
	Window *p;

	if (focus)
		focus_layer = w->layer;
	
	/* focus unlink any possible old occurance */
	if (wm_wins == w)
		wm_wins = wm_wins->next_global;
	else if (wm_wins)
		for (p = wm_wins; p->next_global; p = p->next_global)
			if (p->next_global == w) {
				p->next_global = p->next_global->next_global;
				break;
			}
	
	/* then link at the right place */
	if (wm_wins == NULL || 
	    (w->layer < wm_wins->layer) ||
	    (w->layer == wm_wins->layer && focus)) {
	    	w->next_global = wm_wins;
	    	wm_wins = w;
	} else {
		for (p = wm_wins; p->next_global; p = p->next_global)
			if (w->layer < p->next_global->layer ||
			    (w->layer == p->next_global->layer && focus))
			    	break;
		w = p->next_global;
		p->next_global = w;
	}
}

void focus_window(Window *w)
{
	place_window(w, 1);
}

static void fetch_wm_data(YwPacket *pkt, Window *win)
{
	YwWord *w;
	w = yw_packet_word(pkt, 1);
	yw_word_fetch_int(yw_tag_find(w, "wm_width"), &win->wm_width);
	yw_word_fetch_int(yw_tag_find(w, "wm_height"), &win->wm_height);
	yw_word_fetch_int(yw_tag_find(w, "wm_offset_x"), &win->wm_off_x);
	yw_word_fetch_int(yw_tag_find(w, "wm_offset_y"), &win->wm_off_y);
	yw_word_fetch_int(yw_tag_find(w, "wm_pos_x"), &win->x);
	yw_word_fetch_int(yw_tag_find(w, "wm_pos_y"), &win->y);
}

static void open_window(CallbackData *cd)
{
	Window *w;
	int focus;
	int wm_cid = 0;
	int did_wm = 0;

	w = YW_NEW_0(Window);

	w->parent = cd->conn;

	w->width = int_tag(cd, "width", 40);
	w->height = int_tag(cd, "height", 10);
	w->virtual_width = int_tag(cd, "virtual_width", w->width);
	w->virtual_height = int_tag(cd, "virtual_height", w->height);
	w->layer = int_tag(cd, "layer", 0);
	focus = int_tag(cd, "focus", 1);

	/* defaults for wm */
	w->wm_width = w->width;
	w->wm_height = w->height;
	w->x = 10;
	w->y = 3;
	fetch_wm_data(cd->pkt, w);
	
	printk(YL_DEBUG0 "open_window: size(%d->%d, %d->%d) l=%d f=%d", 
			 w->width, w->virtual_width,
			 w->height, w->virtual_height,
			 w->layer, focus);
	printk(YL_DEBUG1 "open_window: wm: (%d, %d)@(%d, %d), pos=(%d, %d)",
			w->wm_width, w->wm_height,
			w->wm_off_x, w->wm_off_y,
			w->x, w->y);
			
	lock();
	if (conn_wm && conn_wm != cd->conn) {
		YwPacket *pkt;
		const char *kw;
		
		wm_cid = conn_wm->cid;
		pkt = yw_packet_new(yw_call_packet);
		yw_packet_append_keyword(pkt, "wm_new_window");
		yw_packet_append_words(pkt, yw_packet_word(cd->pkt, 1), -1);

		yw_conn_send(conn_wm->conn, pkt);
		pkt = yw_conn_recv_reply(conn_wm->conn, -1);
		if (pkt &&
		    yw_word_fetch_keyword(yw_packet_word(pkt, 0), &kw) == 0 &&
		    strcmp(kw, "wm_new_window_accepted") == 0) {
				fetch_wm_data(pkt, w);
				did_wm++;
		}
		yw_packet_free(pkt);
	}
	
	printk(YL_DEBUG1 "open_window: did=%d wm: (%d, %d)@(%d, %d), "
			"pos=(%d, %d)", did_wm,
			w->wm_width, w->wm_height,
			w->wm_off_x, w->wm_off_y,
			w->x, w->y);
			
	/* make buffers */
	w->client_area_buffer = yw_buffer_new(&bufcb, NULL,
			w->virtual_width, w->virtual_height, 0);
	w->wm_buffer = yw_buffer_new(&bufcb, NULL,
			w->wm_width, w->wm_height, 0);
	
	/* assign ids and link */
	w->win_id = cd->conn->current_win_id++;
	w->next = cd->conn->wins;
	cd->conn->wins = w;
	
	w->wm_win_id = wm_current_win_id++;
	place_window(w, focus);

	if (did_wm && conn_wm && 
	    conn_wm != cd->conn && conn_wm->cid == wm_cid) {
	    	send_packet(conn_wm, yw_packet_make(yw_reply_packet,
				"i" "wm_win_id", w->wm_win_id,
				YW_END), PRI_WM);
	}
	unlock();
	
	yw_conn_send_and_free(cd->conn->conn, 
		yw_packet_make(yw_reply_packet,
			"i" "win_id", w->win_id,
			YW_END));

	printk(YL_DEBUG0 "open_window: win_id=%d wm_win_id=%d",
			w->win_id, w->wm_win_id);
			
	cd->reply_sent++;
}

static void kill_win(Window *w)
{
	Window *p;

	lock();
	
	if (w == w->parent->wins)
		w->parent->wins = w->parent->wins->next;
	else {
		for (p = w->parent->wins; p->next; p = p->next)
			if (p->next == w)
				break;
		p->next = p->next->next;
	}

	if (w == wm_wins)
		wm_wins = wm_wins->next_global;
	else {
		for (p = wm_wins; p->next_global; p = p->next_global)
			if (p->next_global == w)
				break;
		p->next_global = p->next_global->next_global;
	}

	if (conn_wm)
		send_packet(conn_wm, yw_packet_make(yw_void_call_packet,
			"i" "wm_window_closed", w->wm_win_id,
			YW_END), PRI_WM);
	unlock();

	yw_buffer_free(w->wm_buffer);
	yw_buffer_free(w->client_area_buffer);
	yw_free(w);
}

static void close_window(CallbackData *cd)
{
	Window *w;
	int id;

	yw_word_fetch_int(yw_packet_word(cd->pkt, 1), &id);

	printk(YL_DEBUG1 "close_window: %d", id);
	
	for (w = cd->conn->wins; w; w = w->next)
		if (w->win_id == id)
			break;
			
	if (w == NULL) {
		cd->err = "close_window: nothing to kill";
		return;
	}

	kill_win(w);
	refresh_display();
}

void approx(YwString *str);

static void print(CallbackData *cd)
{
	Window *w;
	int id;
	YwString *str;
	char *local = NULL;

	yw_word_fetch_string(yw_packet_word(cd->pkt, 1), &str);
	
	id = cd->conn->goto_id;

	yw_string_get_cstring(str, NULL, &local, NULL);
	printk(YL_DEBUG1 "print: '%s' goto_id=%d", local, id);
	yw_free(local);
	
	for (w = cd->conn->wins; w; w = w->next)
		if (w->win_id == id)
			break;
			
	if (w == NULL) {
		cd->err = "print: window not found";
		return;
	}

	/* 
	 * this will precache characters widths and replace 
	 * inaccessible characteres by Qrczak's approximations.
	 */
	approx(str);

	yw_buffer_puts(w->client_area_buffer, str);
}

static void do_cache_widths(void *userdata, const YwString *str)
{
	(void)userdata;
	precache_widths(str);
}

static int do_char_width(void *userdata, uint32_t ch)
{
	(void)userdata;
	return char_width(ch);
}

static void do_goto(CallbackData *cd)
{
	Window *win;
	int win_id, x, y;
	
	if (yw_word_fetch_int(yw_packet_word(cd->pkt, 1), &win_id) ||
  	    yw_word_fetch_int(yw_packet_word(cd->pkt, 2), &x) ||
	    yw_word_fetch_int(yw_packet_word(cd->pkt, 3), &y)) {
		cd->err = "goto: bad args";
		return;
	}
		
	printk(YL_DEBUG1 "goto: win=%d to (%d, %d)",
			win_id, x, y);
	for (win = cd->conn->wins; win; win = win->next)
		if (win->win_id == win_id)
			break;
	if (win == NULL)
		cd->err = "goto: window not found";
	else {
		cd->conn->goto_id = win_id;
		yw_buffer_goto(win->client_area_buffer, x, y);
	}
}

static void set_origin(CallbackData *cd)
{
	Window *win;
	int win_id, x, y;
	
	if (yw_word_fetch_int(yw_packet_word(cd->pkt, 1), &win_id) ||
  	    yw_word_fetch_int(yw_packet_word(cd->pkt, 2), &x) ||
	    yw_word_fetch_int(yw_packet_word(cd->pkt, 3), &y)) {
		cd->err = "set_origin: bad args";
		return;
	}
		
	printk(YL_DEBUG1 "set_origin: win=%d to (%d, %d)",
			win_id, x, y);
	for (win = cd->conn->wins; win; win = win->next)
		if (win->win_id == win_id)
			break;
	if (win == NULL)
		cd->err = "set_origin: window not found";
	else {
		if (x < 0 || y < 0)
			cd->err = "set_origin: x < 0 || y < 0";
		else {
			if (x + win->width > win->virtual_width)
				x = win->virtual_width - win->width;
			if (y + win->height > win->virtual_height)
				y = win->virtual_height - win->height;
			if (x < 0)	
				x = 0;
			if (y < 0)
				y = 0;

			win->off_x = x;
			win->off_y = y;
		}
	}
}

static void attr(CallbackData *cd)
{
	const char *name;
	int val;
	YwBufAttr a;
	Window *win;

	if (yw_word_fetch_keyword(yw_packet_word(cd->pkt, 1), &name) ||
	    yw_word_fetch_int(yw_packet_word(cd->pkt, 2), &val)) {
	    	cd->err = "attr: bad args";
		return;
	}
	
	a = yw_bufattr_from_keyword(name);
	if (a == yw_bufattr_bad)
		cd->err = "attr: bad attribute";
	else {
		printk(YL_DEBUG1 "attr: (%s -> %d -> %s) <- %d",
				name, (int)a,
				yw_bufattr_name(a),
				val);
		for (win = cd->conn->wins; win; win = win->next)
			if (win->win_id == cd->conn->goto_id)
				break;
		if (win == NULL)
			cd->err = "attr: window not found";
		else
			yw_buffer_set_attr(win->client_area_buffer, a, val);
	}
}

static void join(YwString *str, CallbackData *cd)
{
	YwWord *w;
	int len = 0;
	uint32_t *buf;

	for (w = yw_packet_word(cd->pkt, 1); w; w = yw_word_next(w), len++)
		if (yw_word_type(w) != yw_string_word)
			break;
	buf = yw_malloc(len * sizeof(uint32_t));
	len = 0;
	for (w = yw_packet_word(cd->pkt, 1); w; w = yw_word_next(w), len++)
		if (yw_word_type(w) != yw_string_word)
			break;
		else {
			YwString *str;
			yw_word_fetch_string(w, &str);
			buf[len] = str->chars[0];
		}
	yw_string_assign_utf32(str, buf, len);
	yw_free(buf);

}

static void cw(CallbackData *cd, int fallbacks)
{
	YwString str, s;
	int i, w, j;

	join(&str, cd);
	precache_widths(&str);
	
	for (i = 0; i < str.len; i++) {
		w = char_width(str.chars[i]);
		yw_string_assign_one_char(&s, str.chars[i]);
		if (w == -1 && fallbacks) {
			approx(&s);
			w = 0;
			for (j = 0; j < s.len; j++)
				w += char_width(s.chars[j]);
			yw_string_free(&s);
			yw_string_assign_one_char(&s, str.chars[i]);
		}
		yw_packet_append_string(cd->ret, &s);
		yw_string_free(&s);
		if (w == -1)
			yw_packet_append_keyword(cd->ret, "none");
		else
			yw_packet_append_int(cd->ret, w);
	}
}

static void cb_char_width(CallbackData *cd)
{
	yw_packet_append_keyword(cd->ret, "char_width"); 
	cw(cd, 1);
}

static void no_fallback_char_width(CallbackData *cd)
{
	yw_packet_append_keyword(cd->ret, "no_fallback_char_width");
	cw(cd, 0);
}

static void flush(CallbackData *cd)
{
	Window *w;
	int id;

	id = cd->conn->goto_id;

	printk(YL_DEBUG1 "flush: goto_id=%d", id);
	
	for (w = cd->conn->wins; w; w = w->next)
		if (w->win_id == id)
			break;
			
	/* hm.. in fact we don't need window here, but maybe
	 * someday we will, so require it to be set properly... */
	if (w == NULL) {
		cd->err = "flush: window not found";
		return;
	}

	refresh_display();
}

void kill_windows(Conn *c)
{
	while (c->wins)
		kill_win(c->wins);
	refresh_display();
}

/*
 * attr TAGS
 * flush
 * print s
 * set_origin win x y
 * goto win x y
 * close_window win
 * open_window TAGS
 * char_width STRINGS
 * no_fallback_char_width STRINGS
 */

void install_window_callbacks()
{
	bufcb.char_width = do_char_width;
	bufcb.cache_widths = do_cache_widths;
	
	install_callback("open_window", HAS_RETURN | ARG_TAGS, 
			 open_window, NULL);
	install_callback("close_window", yw_int_word, 
			 close_window, NULL);
	install_callback("set_origin", 0, set_origin, NULL);
	install_callback("goto", 0, do_goto, NULL);
	install_callback("flush", yw_void_word, flush, NULL);
	install_callback("print", yw_string_word, print, NULL);
	install_callback("attr", ARG_TAGS, attr, NULL);
	install_callback("char_width", HAS_RETURN, cb_char_width, NULL);
	install_callback("no_fallback_char_width", HAS_RETURN, 
			 no_fallback_char_width, NULL);
}
