/* $Id: printk.c,v 1.5 2001/05/23 08:46:01 malekith Exp $ */

/* vsnprintf() */
#define _XOPEN_SOURCE 500
#include "serv.h"


static char writebuf[4096];
static int pos;
static YwLock buf_lock = YW_LOCK_INIT;

int console_log_lev = 10;
int discard_at = 6;

int read_log_buf(void *buf, int size)
{
	int p;

	yw_lock_ro(&buf_lock);

	p = pos;
	if (writebuf[p] == '\0')
		p = 0;
	else {
		while (writebuf[p] != '\n' && p < (int)sizeof(writebuf))
			p++;
		if (p == (int)sizeof(writebuf)) {
			p = 0;
			while (writebuf[p] != '\n' && 
			       p < (int)sizeof(writebuf))
				p++;
			if (p == (int)sizeof(writebuf)) {
				yw_unlock_ro(&buf_lock);
				return 0;
			}
		}
		p++;
	}

	if (p > pos) {
		if (size > ((int)sizeof(writebuf) - p) + pos)
			size = (sizeof(writebuf) - p) + pos;
	} else {
		if (size > pos - p)
			size = pos - p;
	}

	if (size > (int)sizeof(writebuf) - p) {
		memcpy(buf, writebuf + p, sizeof(writebuf) - p);
		memcpy((char*)buf + sizeof(writebuf) - p, writebuf, 
		       size - (sizeof(writebuf) - p));
	} else {
		memcpy(buf, writebuf + p, size);
	}

	yw_unlock_ro(&buf_lock);

	return size;
}

static void writek(const char *p, int len)
{
	int n;

	yw_lock_rw(&buf_lock);
	n = sizeof(writebuf) - pos;
	if (len > n) {
		memcpy(writebuf + pos, p, n);
		memcpy(writebuf, p + n, len - n);
		pos = len - n;
	} else {
		memcpy(writebuf + pos, p, len);
		pos += len;
	}
	yw_unlock_rw(&buf_lock);
}

void vprintk(const char *fmt, va_list ap)
{
	char buf[1026];
	char *p;
	int lev = 2, n;

	buf[1024] = 0;
	vsnprintf(buf, 1024, fmt, ap);
	p = buf;
	if (buf[0] == '<' &&
	    buf[1] >= '0' && buf[1] <= '7' &&
	    buf[2] == '>') {
	    	lev = buf[1] - '0';
	    	p += 3;
	}
	if (lev >= discard_at)
		return;

	n = strlen(p);
	if (p[n-1] != '\n') {
		p[n++] = '\n';
		p[n] = 0;
	}
	if (lev <= console_log_lev)
		fprintf(stderr, "%s", p);
	writek(p, n);
}

void printk(const char *fmt, ...)
{
	va_list ap;
	
	va_start(ap, fmt);
	vprintk(fmt, ap);
	va_end(ap);
}
