/* $Id: main.c,v 1.13 2001/05/23 08:46:01 malekith Exp $ */

#include "serv.h"

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <signal.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <sys/poll.h>

#ifdef YW_HAS_PTHREAD
# include <pthread.h>
#endif

int debug_mode = 0;

extern int console_log_lev;
extern int discard_at;

uint8_t *authority;

int current_cid = 1;
Conn *conns;
Conn *conn_display, *conn_wm;

int sock;
int port;

void lock()
{
	/* noop */
}

void unlock()
{
	/* noop */
}

void init_sock()
{
#ifdef YW_HAS_IPV6
	struct sockaddr_in6 sin6;
	int use6 = 0;
#endif
	struct sockaddr_in sin;
	int e;
	socklen_t l;

#ifdef YW_HAS_IPV6
	sock = socket(AF_INET6, SOCK_STREAM, 0);
	/* this can fail, for ex when ipv6 is not compiled into
	 * the kernel */
	if (sock != -1)
		use6++;
	else
#endif
		sock = socket(AF_INET, SOCK_STREAM, 0);

	memset(&sin, 0, sizeof(sin));
	sin.sin_family = AF_INET;
	
#ifdef YW_HAS_IPV6
	memset(&sin6, 0, sizeof(sin6));
	sin6.sin6_family = AF_INET6;
	
	if (use6)
		e = bind(sock, (struct sockaddr*)&sin6, sizeof(sin6));
	else
#endif
		e = bind(sock, (struct sockaddr*)&sin, sizeof(sin));

	if (e) {
		perror("bind");
		exit(1);
	}
	
	if (listen(sock, 8)) {
		perror("listen");
		exit(1);
	}

#ifdef YW_HAS_IPV6
	if (use6) {
		l = sizeof(sin6);
		getsockname(sock, (struct sockaddr*)&sin6, &l);
		port = ntohs(sin6.sin6_port);
	} else
#endif
	{
		l = sizeof(sin);
		getsockname(sock, (struct sockaddr*)&sin, &l);
		port = ntohs(sin.sin_port);
	}
}

void pkt_dump(YwPacket *pkt)
{
	YwWord *w;
	char *s = NULL;
	const char *kw;
	int i;
	void *p;
	YwString *str;

	if (discard_at <= 6)
		return;

	printk(YL_DEBUG "pkt: %c", yw_packet_type(pkt));

	for (w = yw_packet_word(pkt, 0); w; w = yw_word_next(w))
		if (yw_word_fetch_keyword(w, &kw) == 0)
			printk(YL_DEBUG " '%s'", kw);
		else if (yw_word_fetch_int(w, &i) == 0)
			printk(YL_DEBUG " %d", i);
		else if (yw_word_fetch_void(w) == 0)
			printk(YL_DEBUG " [void]");
		else if (yw_word_fetch_ptr(w, &p) == 0)
			printk(YL_DEBUG " %p", p);
		else if (yw_word_fetch_string(w, &str) == 0) {
			s = NULL;
			yw_string_get_cstring(str, NULL, 
					&s, NULL);
			printk(YL_DEBUG " \"%s\"", s);
			yw_free(s);
		} else
			printk(YL_DEBUG " <unknown>");
}

void free_display(Conn *);
void free_wm(Conn *);
void kill_windows(Conn *c);

static void free_conn(Conn *c)
{
	const char *file;
	int line, state;
	
	yw_conn_get_state(c->conn, &file, &line, &state);
	printk(YL_INFO "client %d [fd = %d] removed "
		       "(state = %s [%d], %s:%d)\n", 
		       c->cid, c->fd, yw_strerror(state), 
		       state, file, line);
		       
	kill_windows(c);
	free_display(c);
	free_wm(c);
	yw_conn_free(c->conn);
	c->conn = NULL;
	yw_free(c);
}

static void *client_proc(void *cv)
{
	Conn *c;
	
	c = (Conn*)cv;

	printk(YL_INFO "accepted socket %d", c->fd);
	
	if (yw_serv_auth(c->conn)) { 
		printk(YL_ERR "auth error: %d", yw_conn_state(c->conn));
		c->state = st_dead;
	} else {
		printk(YL_INFO "auth ok [fd=%d, cid=%d].",
			c->fd, c->cid);
		c->state = st_alive;
	}
	
	return NULL;
}


void process_events(Conn *c)
{
	Event *e;

	while ((e = get_event(c))) {
		if (e->execute)
			e->execute(c, e);
	}
}

void process_packets(Conn *c)
{
	YwPacket *pkt;
	
	do {
		if (yw_conn_state(c->conn)) {
			c->state = st_dead;
			return;
		}

		pkt = yw_conn_recv(c->conn, 0);
		
		if (pkt) {
			pkt_dump(pkt);
			run_callback(c, pkt);
			yw_packet_free(pkt);
		}
	} while (pkt);
		
}

static void loop()
{
	struct pollfd *fds = NULL;
	int nfds = 0;
	int n;
	int did;
	Conn *c, *p;

	for (;;) {
		n = 1;
		for (c = conns; c; c = c->next)
			if (c->state == st_alive)
				n++;
			
		if (n >= nfds) {
			nfds = n * 2;
			fds = yw_realloc(fds, nfds * sizeof(struct pollfd));
		}
		
		fds[0].fd = sock;
		fds[0].events = POLLIN;
		fds[0].revents = 0;
		n = 1;
		for (c = conns; c; c = c->next) {
			if (c->state == st_alive) {
				fds[n].fd = c->fd;
				fds[n].events = POLLIN;
				fds[n].revents = 0;
				n++;
			}
		}
			
		poll(fds, n, 10);
		
		if (fds[0].revents & POLLIN) {
			c = YW_NEW_0(Conn);
			c->fd = accept(sock, 0, 0);
			c->conn = yw_serv_new_conn(c->fd, authority);
			c->next = conns;
			c->cid = current_cid++;
			conns = c;

			did = 0;
#ifdef YW_HAS_PTHREAD
			if (debug_mode == 0) {
				pthread_t t;

				if (pthread_create(&t, 0, client_proc, c))
					printk(YL_ERR "pthread_create FAILED");
				else
					did++;
			}
#endif
			if (!did)
				client_proc(c);
		}

		n = 1;
		for (c = conns; c; c = c->next)
			if (c->fd != fds[n].fd)
				continue;
			else {
				/*if (c->state == st_alive && 
				    fds[n].revents & POLLIN)*/
					process_packets(c);
				if (yw_conn_state(c->conn))
					c->state = st_dead;
				n++;
			}

		for (c = conns; c; c = c->next) {
			if (c->state == st_alive && c->nevents)
				process_events(c);
		}
		
		while (conns && conns->state == st_dead) {
			c = conns;
			conns = conns->next;
			free_conn(c);
		}
		
		for (c = conns; c && c->next; )
			if (c->next->state == st_dead) {
				p = c->next;
				c->next = c->next->next;
				free_conn(p);
			} else
				c = c->next;
	}
}

void install_base_callbacks(void);
void install_display_callbacks(void);
void install_window_callbacks(void);
void install_wm_callbacks(void);
void init_map(void);

int main()
{
	if (getenv("Y_DEBUG_MODE"))
		debug_mode++;
		
	init_sock();
	printk(YL_INFO "listening on %d [self=%lu]", port, pthread_self());

	install_base_callbacks();
	install_display_callbacks();
	install_window_callbacks();
	install_wm_callbacks();
	init_map();

	authority = yw_serv_generate_authority(port);
	
	loop();
	
	return 0;
}
