/* $Id: event.c,v 1.4 2001/05/04 11:04:28 malekith Exp $ */

#include "serv.h"

Event *new_event()
{
	Event *e;

	e = YW_NEW_0(Event);
	e->pri = PRI_INTERNAL;

	return e;
}

void free_event(Event *e)
{
	yw_free(e);
}

static int frame;

int get_frame()
{
	return frame;
}

int get_next_frame()
{
	int r;
	
	r = ++frame;

	return r;
}

void post_event(Event *e, Conn *c)
{
	Event *p;
		
	yw_lock_rw(&c->event_lock);
	if (c->events == NULL || c->events->pri > e->pri) {
		e->next = c->events;
		c->events = e;
	} else {
		for (p = c->events; p->next; p = p->next)
			if (p->next->pri > e->pri)
				break;
		e->next = p->next;
		p->next = e;
	}
	c->nevents++;
	e->frame = get_next_frame();
	yw_unlock_rw(&c->event_lock);
}

Event *get_event(Conn *c)
{
	Event *e;
	
	yw_lock_rw(&c->event_lock);
	if ((e = c->events)) {
		c->events = c->events->next;
		c->nevents--;
	}
	yw_unlock_rw(&c->event_lock);

	return e;
}

static void do_send_packet(Conn *conn, Event *e)
{
	yw_assert(e->userdata);
	yw_conn_send_and_free(conn->conn, e->userdata);
	e->userdata = NULL;
}

void send_packet(Conn *conn, YwPacket *pkt, int pri)
{
	Event *e;

	e = new_event();
	e->pri = pri;
	e->execute = do_send_packet;
	e->userdata = pkt;

	post_event(e, conn);
}

static void do_die(Conn *conn, Event *e)
{
	(void)e;
	conn->state = st_dead;
}

void kill_connection(Conn *conn)
{
	Event *e;

	e = new_event();
	e->pri = PRI_DIE;
	e->execute = do_die;

	post_event(e, conn);
}
