/* $Id: char_width.c,v 1.4 2001/05/04 11:04:28 malekith Exp $ */

#include "serv.h"

#include <yw/intmap.h>
#include <yw/unigfx.h>

static int cw_callback(YwPacket *pkt, YwString *str)
{
	YwWord *w;
	int i = 0, l;
	const char *junk;
	YwString *x;
	YwMapEntry e[] = { {"char_width", 1}, {NULL, 0} };

	yw_word_fetch_mapped_keyword(w = yw_packet_word(pkt, 0), e, NULL, &i);
	if (i == 0)
	    	return -1;
	
	for (i = 0, w = yw_word_next(w); 
	     i < str->len && w; i++, w = yw_word_next(w)) {
	     	if (yw_word_fetch_string(w, &x) ||
		    x->chars[0] != str->chars[i])
		     	break;
		
		w = yw_word_next(w);
		
		l = -1;
		if (yw_word_fetch_int(w, &l) &&
		    yw_word_fetch_keyword(w, &junk))
		     	break;
		
		printk(YL_DEBUG "width(%d '%c') = %d",
			str->chars[i], str->chars[i], l);
		str->chars[i] = l;
	}

	while (i < str->len)
		str->chars[i++] = -1;

	return 0;
}

static int ask_width(YwString *str)
{
	int r = -1, i;
	YwPacket *pkt;
	YwString s;
	
	lock();
	if (conn_display) {
		pkt = yw_packet_make(yw_call_packet,
				"k", "char_width",
				YW_END);
		for (i = 0; i < str->len; i++) {
			yw_string_assign_one_char(&s, str->chars[i]);
			yw_packet_append_string(pkt, &s);
			yw_string_free(&s);
		}
		
		yw_conn_send_and_free(conn_display->conn, pkt);

		pkt = yw_conn_recv_reply(conn_display->conn, -1);
		if (pkt) {
			pkt_dump(pkt);
			r = cw_callback(pkt, str);
			yw_packet_free(pkt);
		}
	}
	unlock();

	if (r)
		for (i = 0; i < str->len; i++)
			str->chars[i] = -1;

	return r;
}

struct Map {
	YwLock lock;
	YwIntMap *intmap;
	int precached_basic;
};

static struct Map *map;

static void add_basics(YwString *str)
{
	YwString *pre;
	int i, j;


	pre = yw_get_precache();
	
	for (i = 0; i < str->len; i++)
		if (yw_string_idx(pre, str->chars[i]) != -1)
			str->chars[i] = 0;
			
	j = 0;
	for (i = 0; i < str->len; i++)
		if (str->chars[i])
			str->chars[j++] = str->chars[i];
	
	yw_string_concat(str, pre);
}

void precache_widths(const YwString *str)
{
	YwString copy;
	YwString lens;
	int i, d;

	yw_string_assign_string(&copy, str);

	yw_lock(&map->lock);
	if (map->intmap == NULL) {
		yw_unlock(&map->lock);
		return;
	}
	
	if (!map->precached_basic) {
		add_basics(&copy);
		map->precached_basic++;
	}
	
	for (d = i = 0; i < str->len; i++)
		if (yw_intmap_get(map->intmap, str->chars[i]) == -2)
			copy.chars[d++] = str->chars[i];
	if (d > 0) {
		copy.len = d;
		yw_string_assign_string(&lens, &copy);
		ask_width(&lens);
		for (i = 0; i < copy.len; i++)
			yw_intmap_add(map->intmap, 
				      (int)copy.chars[i],
				      (int)lens.chars[i]);
	}
	yw_unlock(&map->lock);
}

int char_width(int ch)
{
	int r;
	
	yw_lock(&map->lock);
	if (map->intmap == NULL) {
		yw_unlock(&map->lock);
		return -2;
	}
	/* XXX: hack... */
	if (ch == ' ' || ch == 0) {
		yw_unlock(&map->lock);
		return 1; 
	}
	if (!map->precached_basic) {
		YwString s;
		
		yw_string_assign_empty(&s);
		yw_unlock(&map->lock);
		precache_widths(&s);
		yw_lock(&map->lock);
	}

	r = yw_intmap_get(map->intmap, ch);
	if (r == -2) {
		YwString str;

		yw_string_assign_one_char(&str, ch);
		ask_width(&str);
		yw_intmap_add(map->intmap, ch, r = (int)str.chars[0]);
	}
	yw_unlock(&map->lock);
	return r;
}

void display_present(int is_it)
{
	yw_lock(&map->lock);
	if (is_it) {
		if (map->intmap == NULL) {
			map->intmap = yw_intmap_new();
			yw_intmap_set_default(map->intmap, -2);
			map->precached_basic = 0;
		}
	} else {
		yw_intmap_free(map->intmap);
		map->intmap = NULL;
		map->precached_basic = 0;
	}
	yw_unlock(&map->lock);
}

void init_map()
{
	map = YW_NEW_0(struct Map);
	yw_lock_init(&map->lock);
}
